/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateTransitGatewayPolicyTableRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AssociateTransitGatewayPolicyTableRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_POLICY_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayPolicyTableId").getter(AssociateTransitGatewayPolicyTableRequest.getter(AssociateTransitGatewayPolicyTableRequest::transitGatewayPolicyTableId)).setter(AssociateTransitGatewayPolicyTableRequest.setter(Builder::transitGatewayPolicyTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayPolicyTableId").unmarshallLocationName("TransitGatewayPolicyTableId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentId").getter(AssociateTransitGatewayPolicyTableRequest.getter(AssociateTransitGatewayPolicyTableRequest::transitGatewayAttachmentId)).setter(AssociateTransitGatewayPolicyTableRequest.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("TransitGatewayAttachmentId").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(AssociateTransitGatewayPolicyTableRequest.getter(AssociateTransitGatewayPolicyTableRequest::dryRun)).setter(AssociateTransitGatewayPolicyTableRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_POLICY_TABLE_ID_FIELD, TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateTransitGatewayPolicyTableRequest.memberNameToFieldInitializer();
    private final String transitGatewayPolicyTableId;
    private final String transitGatewayAttachmentId;
    private final Boolean dryRun;

    private AssociateTransitGatewayPolicyTableRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayPolicyTableId = builder.transitGatewayPolicyTableId;
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.dryRun = builder.dryRun;
    }

    public final String transitGatewayPolicyTableId() {
        return this.transitGatewayPolicyTableId;
    }

    public final String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayPolicyTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateTransitGatewayPolicyTableRequest)) {
            return false;
        }
        AssociateTransitGatewayPolicyTableRequest other = (AssociateTransitGatewayPolicyTableRequest)((Object)obj);
        return Objects.equals(this.transitGatewayPolicyTableId(), other.transitGatewayPolicyTableId()) && Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateTransitGatewayPolicyTableRequest").add("TransitGatewayPolicyTableId", (Object)this.transitGatewayPolicyTableId()).add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayPolicyTableId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayPolicyTableId()));
            }
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransitGatewayPolicyTableId", TRANSIT_GATEWAY_POLICY_TABLE_ID_FIELD);
        map.put("TransitGatewayAttachmentId", TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateTransitGatewayPolicyTableRequest, T> g) {
        return obj -> g.apply((AssociateTransitGatewayPolicyTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String transitGatewayPolicyTableId;
        private String transitGatewayAttachmentId;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateTransitGatewayPolicyTableRequest model) {
            super(model);
            this.transitGatewayPolicyTableId(model.transitGatewayPolicyTableId);
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.dryRun(model.dryRun);
        }

        public final String getTransitGatewayPolicyTableId() {
            return this.transitGatewayPolicyTableId;
        }

        public final void setTransitGatewayPolicyTableId(String transitGatewayPolicyTableId) {
            this.transitGatewayPolicyTableId = transitGatewayPolicyTableId;
        }

        @Override
        public final Builder transitGatewayPolicyTableId(String transitGatewayPolicyTableId) {
            this.transitGatewayPolicyTableId = transitGatewayPolicyTableId;
            return this;
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateTransitGatewayPolicyTableRequest build() {
            return new AssociateTransitGatewayPolicyTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateTransitGatewayPolicyTableRequest> {
        public Builder transitGatewayPolicyTableId(String var1);

        public Builder transitGatewayAttachmentId(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

