/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remoteindexbuild.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.utils.Base64;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.settings.SecureString;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.remoteindexbuild.client.RemoteIndexClient;
import org.opensearch.remoteindexbuild.client.RemoteIndexHTTPClientRetryStrategy;
import org.opensearch.remoteindexbuild.model.RemoteBuildRequest;
import org.opensearch.remoteindexbuild.model.RemoteBuildResponse;
import org.opensearch.remoteindexbuild.model.RemoteBuildStatusRequest;
import org.opensearch.remoteindexbuild.model.RemoteBuildStatusResponse;

public class RemoteIndexHTTPClient
implements RemoteIndexClient,
Closeable {
    @Generated
    private static final Logger log = LogManager.getLogger(RemoteIndexHTTPClient.class);
    private static volatile String authHeader = null;
    private final String endpoint;
    private final CloseableHttpClient httpClient;

    public RemoteIndexHTTPClient(String endpoint) {
        this(endpoint, HttpClientHolder.httpClient);
    }

    RemoteIndexHTTPClient(String endpoint, CloseableHttpClient client) {
        if (StringUtils.isEmpty((CharSequence)endpoint)) {
            throw new IllegalArgumentException("No endpoint set for RemoteIndexClient");
        }
        this.endpoint = endpoint;
        this.httpClient = client;
    }

    @Override
    public RemoteBuildResponse submitVectorBuild(RemoteBuildRequest remoteBuildRequest) throws IOException {
        HttpPost buildRequest = this.getHttpPost(this.toJson(remoteBuildRequest));
        try {
            String response = AccessController.doPrivileged(() -> (String)this.httpClient.execute((ClassicHttpRequest)buildRequest, body -> {
                if (body.getCode() < 200 || body.getCode() > 300) {
                    HttpEntity entity = body.getEntity();
                    String responseBody = entity != null ? EntityUtils.toString((HttpEntity)entity) : "";
                    throw new IOException(String.format("Failed to submit build request, got status code: %d, response body: %s", body.getCode(), responseBody));
                }
                return EntityUtils.toString((HttpEntity)body.getEntity());
            }));
            XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response);
            RemoteBuildResponse buildResponse = RemoteBuildResponse.fromXContent(parser);
            if (StringUtils.isBlank((CharSequence)buildResponse.getJobId())) {
                throw new IOException("Invalid response format, empty job_id");
            }
            return buildResponse;
        }
        catch (Exception e) {
            throw new IOException("Failed to execute HTTP request", e);
        }
    }

    private HttpPost getHttpPost(String jsonRequest) {
        HttpPost buildRequest = new HttpPost(String.valueOf(URI.create(this.endpoint)) + "/_build");
        buildRequest.setHeader("Content-Type", (Object)ContentType.APPLICATION_JSON.toString());
        buildRequest.setEntity((HttpEntity)new StringEntity(jsonRequest, ContentType.APPLICATION_JSON));
        if (authHeader != null) {
            buildRequest.setHeader("Authorization", (Object)authHeader);
        }
        return buildRequest;
    }

    @Override
    public RemoteBuildStatusResponse getBuildStatus(RemoteBuildStatusRequest remoteBuildStatusRequest) throws IOException {
        String jobId = remoteBuildStatusRequest.getJobId();
        HttpGet request = new HttpGet(this.endpoint + "/_status/" + jobId);
        if (authHeader != null) {
            request.setHeader("Authorization", (Object)authHeader);
        }
        try {
            String response = AccessController.doPrivileged(() -> (String)this.httpClient.execute((ClassicHttpRequest)request, body -> {
                if (body.getCode() < 200 || body.getCode() > 300) {
                    throw new IOException("Failed to submit status request, got status code: " + body.getCode());
                }
                return EntityUtils.toString((HttpEntity)body.getEntity());
            }));
            XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response);
            return RemoteBuildStatusResponse.fromXContent(parser);
        }
        catch (Exception e) {
            throw new IOException("Failed to execute HTTP request", e);
        }
    }

    private String toJson(ToXContentObject object) throws IOException {
        try (XContentBuilder builder = JsonXContent.contentBuilder();){
            object.toXContent(builder, ToXContentObject.EMPTY_PARAMS);
            String string = builder.toString();
            return string;
        }
    }

    public static void reloadAuthHeader(SecureString username, SecureString password) {
        if (password != null && !password.isEmpty()) {
            if (username == null || username.isEmpty()) {
                throw new IllegalArgumentException("Username must be set if password is set");
            }
            String auth = String.valueOf(username) + ":" + String.valueOf(password.clone());
            byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
            authHeader = "Basic " + new String(encodedAuth, StandardCharsets.UTF_8);
        } else {
            authHeader = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    private static class HttpClientHolder {
        private static final CloseableHttpClient httpClient = HttpClients.custom().setRetryStrategy((HttpRequestRetryStrategy)new RemoteIndexHTTPClientRetryStrategy()).build();

        private HttpClientHolder() {
        }
    }
}

