/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.MetricAggregationBase;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GeoBoundsAggregation
extends MetricAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, GeoBoundsAggregation> {
    @Nullable
    private final Boolean wrapLongitude;
    public static final JsonpDeserializer<GeoBoundsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoBoundsAggregation::setupGeoBoundsAggregationDeserializer);

    private GeoBoundsAggregation(Builder builder) {
        super(builder);
        this.wrapLongitude = builder.wrapLongitude;
    }

    public static GeoBoundsAggregation of(Function<Builder, ObjectBuilder<GeoBoundsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.GeoBounds;
    }

    @Nullable
    public final Boolean wrapLongitude() {
        return this.wrapLongitude;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.wrapLongitude != null) {
            generator.writeKey("wrap_longitude");
            generator.write(this.wrapLongitude.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGeoBoundsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        GeoBoundsAggregation.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::wrapLongitude, JsonpDeserializer.booleanDeserializer(), "wrap_longitude");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.wrapLongitude);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoBoundsAggregation other = (GeoBoundsAggregation)o;
        return Objects.equals(this.wrapLongitude, other.wrapLongitude);
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GeoBoundsAggregation> {
        @Nullable
        private Boolean wrapLongitude;

        public Builder() {
        }

        private Builder(GeoBoundsAggregation o) {
            super(o);
            this.wrapLongitude = o.wrapLongitude;
        }

        private Builder(Builder o) {
            super(o);
            this.wrapLongitude = o.wrapLongitude;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder wrapLongitude(@Nullable Boolean value) {
            this.wrapLongitude = value;
            return this;
        }

        @Override
        @Nonnull
        public GeoBoundsAggregation build() {
            this._checkSingleUse();
            return new GeoBoundsAggregation(this);
        }
    }
}

