﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/greengrass/Greengrass_EXPORTS.h>
#include <aws/greengrass/model/RuntimeConfiguration.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Greengrass {
namespace Model {
class GetThingRuntimeConfigurationResult {
 public:
  AWS_GREENGRASS_API GetThingRuntimeConfigurationResult() = default;
  AWS_GREENGRASS_API GetThingRuntimeConfigurationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GREENGRASS_API GetThingRuntimeConfigurationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * Runtime configuration for a thing.
   */
  inline const RuntimeConfiguration& GetRuntimeConfiguration() const { return m_runtimeConfiguration; }
  template <typename RuntimeConfigurationT = RuntimeConfiguration>
  void SetRuntimeConfiguration(RuntimeConfigurationT&& value) {
    m_runtimeConfigurationHasBeenSet = true;
    m_runtimeConfiguration = std::forward<RuntimeConfigurationT>(value);
  }
  template <typename RuntimeConfigurationT = RuntimeConfiguration>
  GetThingRuntimeConfigurationResult& WithRuntimeConfiguration(RuntimeConfigurationT&& value) {
    SetRuntimeConfiguration(std::forward<RuntimeConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetThingRuntimeConfigurationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  RuntimeConfiguration m_runtimeConfiguration;
  bool m_runtimeConfigurationHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Greengrass
}  // namespace Aws
