﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/UnaggregatedField.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {

/**
 * <p>The unaggregated field well for the table.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TableUnaggregatedFieldWells">AWS
 * API Reference</a></p>
 */
class TableUnaggregatedFieldWells {
 public:
  AWS_QUICKSIGHT_API TableUnaggregatedFieldWells() = default;
  AWS_QUICKSIGHT_API TableUnaggregatedFieldWells(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API TableUnaggregatedFieldWells& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The values field well for a pivot table. Values are unaggregated for an
   * unaggregated table.</p>
   */
  inline const Aws::Vector<UnaggregatedField>& GetValues() const { return m_values; }
  inline bool ValuesHasBeenSet() const { return m_valuesHasBeenSet; }
  template <typename ValuesT = Aws::Vector<UnaggregatedField>>
  void SetValues(ValuesT&& value) {
    m_valuesHasBeenSet = true;
    m_values = std::forward<ValuesT>(value);
  }
  template <typename ValuesT = Aws::Vector<UnaggregatedField>>
  TableUnaggregatedFieldWells& WithValues(ValuesT&& value) {
    SetValues(std::forward<ValuesT>(value));
    return *this;
  }
  template <typename ValuesT = UnaggregatedField>
  TableUnaggregatedFieldWells& AddValues(ValuesT&& value) {
    m_valuesHasBeenSet = true;
    m_values.emplace_back(std::forward<ValuesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<UnaggregatedField> m_values;
  bool m_valuesHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
