/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validation;

import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.xml.ls.LS;
import com.thaiopensource.resolver.xml.sax.SAXResolver;
import com.thaiopensource.validation.Validator2;
import com.thaiopensource.validation.ValidatorHandler2;
import com.thaiopensource.xml.sax.DraconianErrorHandler;
import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

class ValidatorImpl
extends Validator2 {
    private final ValidatorHandler2 handler;
    private XMLReader cachedXMLReader = null;
    private LSResourceResolver cachedResourceResolver = null;
    private boolean needReset = false;
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";

    public ValidatorImpl(ValidatorHandler2 validatorHandler2) {
        this.handler = validatorHandler2;
    }

    @Override
    public void reset() {
        this.handler.reset();
        this.needReset = false;
        this.handler.setErrorHandler(null);
        this.handler.setResourceResolver(null);
    }

    @Override
    public void validate(Source source, Result result) throws SAXException, IOException {
        block9: {
            if (source == null) {
                throw new NullPointerException();
            }
            try {
                if (source instanceof SAXSource) {
                    if (result != null && !(result instanceof SAXResult)) {
                        throw new IllegalArgumentException();
                    }
                    this.doValidate((SAXSource)source, result);
                    break block9;
                }
                if (source instanceof StreamSource) {
                    if (result != null && !(result instanceof StreamResult)) {
                        throw new IllegalArgumentException();
                    }
                    this.doValidate(new SAXSource(SAXSource.sourceToInputSource(source)), result);
                    break block9;
                }
                if (source instanceof DOMSource) {
                    if (result != null && !(result instanceof DOMResult)) {
                        throw new IllegalArgumentException();
                    }
                    this.doValidate((DOMSource)source, (DOMResult)result);
                    break block9;
                }
                throw new IllegalArgumentException("unsupported type of Source: " + source.getClass().getName());
            }
            catch (TransformerException transformerException) {
                throw new SAXException(transformerException);
            }
        }
    }

    private void doValidate(DOMSource dOMSource, DOMResult dOMResult) throws SAXException, IOException, TransformerException {
        throw new IllegalArgumentException();
    }

    private TransformerHandler getIdentityTransformerHandler() throws SAXException, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (!transformerFactory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            throw new SAXException("TransformerFactory must implement SAXTransformerFactory");
        }
        return ((SAXTransformerFactory)transformerFactory).newTransformerHandler();
    }

    private void doValidate(SAXSource sAXSource, Result result) throws SAXException, IOException, TransformerConfigurationException {
        if (result == null) {
            this.doValidate(sAXSource, null, null, null);
        } else if (result instanceof SAXResult) {
            SAXResult sAXResult = (SAXResult)result;
            this.doValidate(sAXSource, sAXResult.getHandler(), sAXResult.getLexicalHandler(), null);
        } else {
            TransformerHandler transformerHandler = this.getIdentityTransformerHandler();
            transformerHandler.setResult(result);
            this.doValidate(sAXSource, transformerHandler, transformerHandler, transformerHandler);
        }
    }

    private void doValidate(SAXSource sAXSource, ContentHandler contentHandler, LexicalHandler lexicalHandler, DTDHandler dTDHandler) throws SAXException, IOException {
        Object object;
        XMLReader xMLReader = sAXSource.getXMLReader();
        if (xMLReader == null) {
            object = this.handler.getResourceResolver();
            if (this.cachedXMLReader != null && this.cachedResourceResolver == object) {
                xMLReader = this.cachedXMLReader;
            } else {
                Resolver resolver = null;
                if (object != null) {
                    resolver = LS.createResolver((LSResourceResolver)object);
                }
                this.cachedXMLReader = xMLReader = new SAXResolver(resolver).createXMLReader();
                this.cachedResourceResolver = object;
            }
        }
        this.handler.setContentHandler(contentHandler);
        this.handler.setDTDHandler(dTDHandler);
        try {
            xMLReader.setProperty(LEXICAL_HANDLER_PROPERTY, lexicalHandler);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        xMLReader.setContentHandler(this.handler);
        xMLReader.setDTDHandler(this.handler);
        object = this.handler.getErrorHandler();
        if (object == null) {
            object = new DraconianErrorHandler();
        }
        xMLReader.setErrorHandler((ErrorHandler)object);
        if (this.needReset) {
            this.handler.reset();
        } else {
            this.needReset = true;
        }
        xMLReader.parse(sAXSource.getInputSource());
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.handler.setErrorHandler(errorHandler);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.handler.getErrorHandler();
    }

    @Override
    public void setResourceResolver(LSResourceResolver lSResourceResolver) {
        this.handler.setResourceResolver(lSResourceResolver);
    }

    @Override
    public LSResourceResolver getResourceResolver() {
        return this.handler.getResourceResolver();
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.handler.getFeature(string);
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.handler.setFeature(string, bl);
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.handler.setProperty(string, object);
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.handler.getProperty(string);
    }
}

