---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: スタンドアップ、レトロスペクティブ、ベロシティ
---

<!-- vale gitlab_base.FutureTense = NO -->

スプリント計画やレビューなどの主要なScrumセレモニーに加えて、チームはGitLabを使用して、同一の場所と分散した環境の両方で、以下の一般的なScrumセレモニーを促進できます:

- 毎日のスタンドアップ
- レトロスペクティブ
- ストーリーポイント
- ベロシティとボラティリティ

このページは、[入門的なScrumチュートリアル](_index.md)の概念とワークフローに基づいています。そのチュートリアルを完了していない場合は、先に進む前に完了する必要があります。

## 毎日のスタンドアップ {#daily-stand-ups}

一般的なガイドライン:

- スタンドアップを15分以内に制限します。
- ステータスアップデートを超えたディスカッションが必要なトピックがある場合は、関係者がスタンドアップ後に別途集まってさらにディスカッションできるように、ディスカッションを延期します。

### 同期スタンドアップ {#synchronous-stand-up}

同じ場所にいる場合は、同じ部屋に集まり、**Current Sprint**（現在のスプリント）ボードを確認して、それぞれのイシューの更新について話し合います。

分散している場合は、ビデオ通話に参加し、1人に画面共有を操作させて現在のスプリントボードをレビューしてもらいます。

現在のスプリントボードを一緒にレビューする代わりに、次の形式を使用できます。各チームメンバーは、次の3つの質問に答える必要があります:

- 「昨日、何を達成しましたか？」
- 「今日は何に取り組みますか？」
- 「何かによってブロックされていますか、またはすぐにブロックされますか？」

### 非同期スタンドアップ {#asynchronous-stand-up}

GitLabで非同期のスタンドアップを促進するために、いくつかの異なるオプションがあります:

- チームのチャットツールで: 自動化を使用して、各チームメンバーからのスタンドアップをレポートします。GitLabでは、社内で[Geekbot](https://geekbot.com/)を使用しています。
- GitLabで、次の手順を実行します:

  1. **Stand-up**（Stand-up）というイシューを作成し、現在のイテレーションに追加します。
  1. スプリントの各日に、最初にスタンドアップをレポートする人は、日付の入った新しいコメントを作成し、次に更新内容をコメントとして追加する必要があります。
  1. 各チームメンバーは、それぞれの更新内容をスレッドとしてディスカッションに追加します。デモプロジェクトで[例をご覧ください](https://gitlab.com/tech-marketing/demos/gitlab-agile-demo/scrum-public-demo/application-b/-/issues/6)。

## スプリントレトロスペクティブ {#sprint-retrospectives}

レトロスペクティブは、チームがプロセスの改善を特定し、進捗を祝うための、とがめられない機会です。多くのレトロスペクティブ形式から選択できます。

<!-- vale gitlab_base.InclusiveLanguage = NO -->
James Shoreは、著書「The Art ofアジャイル」で[レトロスペクティブの実施方法に関する優れた概要](https://www.jamesshore.com/v2/books/aoad1/retrospectives)を提供しています。
<!-- vale gitlab_base.InclusiveLanguage = YES -->

### 同期レトロスペクティブ {#synchronous-retrospectives}

レトロスペクティブ中に[イテレーションレポート](../../user/group/iterations/_index.md#iteration-report)をレビューすると役立つ場合があります。

完了したイテレーションのイテレーションレポートをレビューするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **Plan** > **イテレーション**を選択します。
1. 上部にある**完了**を選択し、イテレーションのケイデンスを選択します。
1. 最も最近完了したイテレーションを選択します。

### 非同期のレトロスペクティブ {#asynchronous-retrospectives}

非同期のレトロスペクティブには、GitLabイシューを使用できます。

1. 現在のイテレーションで、**Retrospective**（Retrospective）というタイトルの新しいイシューを作成します。

   同期レトロスペクティブと同じ形式の多くを適用できます。James Shoreが提案したレトロスペクティブの概要を適用する[イシューの例を参照してください](https://gitlab.com/tech-marketing/demos/gitlab-agile-demo/scrum-public-demo/application-b/-/issues/7)。

1. アクションアイテムが多い場合は、レトロスペクティブとは別に、それらを個別に追跡するために、別のイシューを作成することを検討してください。
1. チームがアクションアイテムのトリアージを終了したら、レトロスペクティブイシューを閉じます。

## ストーリーポイント {#story-points}

ストーリーを完了するために必要な相対的な複雑さと労力を特定するために、ストーリーポイントを使用できます。ストーリーポイントは、計画プロセス中にスコープと実装のトレードオフを特定してディスカッションするのにも役立ちます。

GitLabでは、チームはイシューまたはタスクの**weight**（weight）フィールドを使用してストーリーポイントをキャプチャします。見積もり戦略に応じて、ストーリー（イシュー）またはタスクにウェイトを設定できます。

### ストーリーポイントの値を決定する {#deciding-the-value-of-story-points}

0、1、2、3、5、8、13、20、および40のストーリーポイントスケールには、変更されたフィボナッチ数列を使用する必要があります。Mike Cohnが[指摘する](https://www.mountaingoatsoftware.com/blog/why-the-fibonacci-sequence-works-well-for-estimating)ように、[ウェーバーの法則](https://en.wikipedia.org/wiki/Weber%E2%80%93Fechner_law#Weber's_law)を明確にするとき、「互いに近すぎる数値は、見積もりとして区別することが不可能です」。

単一のストーリーポイントの値を決定する際に、単一のストーリーポイントのベースライン定義を、デベロッパーの「理想的な」1日に等しく設定すると役立ちます。そのような日には、デベロッパーは非常に生産的で、何にもブロックされず、1日を通してフローを維持します。

チームと協力して、単一のストーリーポイントの異なる値に合意することができます。定義を決定した後、それを変更しないことが重要です。変更すると、ベロシティとボラティリティが、その後の数回のスプリントで不正確になる可能性があることに注意してください。

たとえば、イテレーションごとに4〜10個のユーザーストーリーを提供することを目標とする場合は、ポイント値が3を超えるストーリーを2つ以上の小さいストーリーに分割します。理想的には、チームはウェイトが1つまたは2つになるまで、ストーリーを分割または結合するように取り組む必要があります。

{{< alert type="note" >}}

ステークホルダーは、チームのパフォーマンスを測定したり、[あるチームを別のチームと比較したり](https://towardsdatascience.com/why-story-points-are-a-horrible-metric-for-software-engineers-421bc8971f11)するために、ストーリーポイントを絶対に使用しないでください。

{{< /alert >}}

## ベロシティとボラティリティ {#velocity-and-volatility}

時間が経つにつれて、チームはストーリーポイントを使用してベロシティを理解できます。ベロシティを理解することは、スプリントのスコープのサイズを調整し、チーム外のステークホルダーとのより信頼できる期待値を設定する際に役立ちます。

以前のいくつかのスプリントで提供されたストーリーポイントの数を平均することにより、**velocity**（ベロシティ）を計算できます。

**Volatility**（ボラティリティ）は、以前のスプリントで提供されたストーリーポイントの数の標準偏差を、現在のベロシティで割ったもので表されます。

チームのボラティリティを知ることは、あるイテレーションから別のイテレーションにストーリーを完了する際に、どの程度予測可能かを理解する上で重要です。改善に焦点を当てる最も重要な分野の1つは、チームのボラティリティを下げることです。

次のセクションでは、9回のイテレーションで同じ数のストーリーポイントを完了した2つのチームを見ていきます。ボラティリティが低いほど、将来のチームのパフォーマンスを予測する際の予測可能性が高まり、最終的にはチームがステークホルダーとのより良い期待値を設定できるようになることがわかります。

### ベロシティとボラティリティの追跡スプレッドシートを作成する {#create-a-velocity-and-volatility-tracker-spreadsheet}

ベロシティとボラティリティがネイティブにGitLabに統合されるまで（[エピック435](https://gitlab.com/groups/gitlab-org/-/epics/435)を参照）、次のスプレッドシートのように、チームのベロシティとボラティリティを追跡できます:

![Scrumチームのベロシティとボラティリティ追跡を表示するスプレッドシート。](img/velocity_chart_v17_3.png)

この例では、Googleシートを使用します。好みのスプレッドシートソフトウェアに合わせて数式を調整する必要があるかもしれません。

そのようなスプレッドシートを作成するには、次の列を作成して入力された状態にします。

現在のベロシティとボラティリティを計算するには:

- **イテレーション**: 過去のイテレーションの番号またはトピック。
- **Story Points Completed**（ストーリーポイント完了）
- **Velocity**（ベロシティ）:
  - 最初のセルの数値は、**Story Points Completed**（ストーリーポイント完了）列と同じです。
  - 他のすべてのセルには、以前のいくつかのスプリントで配信されたストーリーポイントの平均数が表示されます。この例では、最大4つを使用します。
  - たとえば、`C10`セルには次の数式があります：`=AVERAGE(B7:B10)`。
- **Volatility**（ボラティリティ）:
  - 以前のスプリントで配信されたストーリーポイントの数の標準偏差を、現在のベロシティで割って計算します。
  - たとえば、`D10`セルには次の数式があります：`=(STDEV(B7:B10)/C10)`。

将来のストーリーポイントの完了数を予測するには:

- 残りのバックログポイントのセル。この例では、`F4`です。
- **Future Iteration**（将来のイテレーション）: 将来のイテレーションの番号またはトピック。
- **Worst Case**（最悪のケース）: 各イテレーション後の残りのストーリーポイントの最悪のケースの予測。
  - 計算は、最後に完了したイテレーションのベロシティとボラティリティを参照します。ここでは:
    - ボラティリティ: `C10`
    - ベロシティ: `D10`
  - 最初のセルの数式は、`F4`セルの数値から減算されます。例: `=F4-(C10*(1-D10))`。
  - 他のすべてのセルは、上記のセルから減算されます。たとえば、`H10`セルには次の数式があります：`=H9-($C$10*(1-$D$10))`。
- **Expected**（予想）: 各イテレーション後の残りのストーリーポイントの現実的な予測。残りのストーリーポイントから、最新の計算されたベロシティを減算します。
  - 最初のセルの数式は、`F4`セルの数値から減算されます。例: `=F4-$C$10`。
  - 他のすべてのセルは、上記のセルから減算されます。たとえば、`I10`セルには次の数式があります：`=I9-$C$10`。
- **Best Case**（ベストケース）: 各イテレーション後の残りのストーリーポイントの最良のケースの予測。
  - 最悪のケースと同様に、計算は最後に完了したイテレーションのベロシティとボラティリティを参照します。
  - 最初のセルの数式は、`F4`セルの数値から減算されます。例: `=F4-(C10*(1+D10))`。
  - 他のすべてのセルは、上記のセルから減算されます。たとえば、`J10`セルには次の数式があります：`=J9-($C$10*(1+$D$10))`。
- 予測を示す折れ線チャート:
  - `Worst Case, Expected and Best Case`とチャートにタイトルを付けます
  - 上記の4つの列に範囲を設定します。
  - 将来のイテレーション列をX軸として設定します。
  - 残りの各列にシリーズを追加します。
  - 次のチェックボックスを選択します: **Use row 1 as headers**（1行目をヘッダーとして使用）、**Use column G as labels**（G列をラベルとして使用）、**Treat labels as text**（ラベルをテキストとして処理）。

トラッカーを維持するには、各スプリントの最後に、チームが完了したストーリーポイント数で更新します。

### ボラティリティが高いと、予測可能性が低下する {#high-volatility-decreases-predictability}

最初の例は、過去9回のスプリントでボラティリティが高いチームです:

| イテレーション | 完了したストーリーポイント | ベロシティ | ボラティリティ |
| --------- | ---------------------- | -------- | ---------- |
| 1         | 8                      | 8        | 0％         |
| 2         | 15                     | 11.5     | 43％        |
| 3         | 11                     | 11.33    | 40％        |
| 4         | 7                      | 10.25    | 35％        |
| 5         | 6                      | 9.75     | 42％        |
| 6         | 15                     | 9.75     | 42％        |
| 7         | 10                     | 9.5      | 43％        |
| 8         | 6                      | 9.25     | 46％        |
| 9         | 8                      | 9.75     | 40％        |

チームがバックログに200ポイント残っていると仮定すると、現在のベロシティとボラティリティを使用して、バックログを完了するまでにさらにスプリントがどのくらい必要かについて、最悪、予想、および最良のシナリオを予測できます。

![高ボラティリティチャート](img/high_volatility_v17_3.png)

チームはバックログを提供します:

- 最良のケースでは、24スプリント。
- 予想されるシナリオでは、30スプリント。
- 最悪のケースでは、43スプリント。

各スプリントが2週間続き、他のビジネス機能が見積もり配達日に依存して作業を調整する場合、最良、予想、最悪のケース間の38週間はあまり実用的ではありません。この幅広い変動性は、Scrumチームと組織の他の部分との間の信頼を損ないます。

### ボラティリティが低いと予測可能性が向上する {#low-volatility-increases-predictability}

2番目の例は、過去9回のスプリントでボラティリティが低いチームを見ています:

| イテレーション | 完了したストーリーポイント | ベロシティ | ボラティリティ |
| --------- | ---------------------- | -------- | ---------- |
| 1         | 9                      | 9        | 0％         |
| 2         | 10                     | 9.5      | 8％         |
| 3         | 11                     | 10       | 10％        |
| 4         | 9                      | 9.75     | 10％        |
| 5         | 8                      | 9.5      | 14％        |
| 6         | 10                     | 9.5      | 14％        |
| 7         | 9                      | 9        | 9％         |
| 8         | 11                     | 9.5      | 14％        |
| 9         | 9                      | 9.75     | 10％        |

前のチームと同様に、このチームも同じ終了ベロシティでしたが、ボラティリティメトリクスははるかに低くなっています。同じ200ストーリーポイントのバックログサイズで、このチームは、バックログを完了するための、より現実的で予測可能なタイムラインを伝えることに、より自信を持っています:

![低ボラティリティチャート](img/low_volatility_v17_3.png)

両方のチームが同じ数のストーリーポイントを完了しました。ただし、ボラティリティが低いチームは、28〜32スプリント（24〜43と比較して）の配達期間を伝えることができ、これはタイムラインの変動性がわずか8週間です。このレベルの予測可能性は、Scrumチームと組織の他の部分との間の信頼を育みます。

### ボラティリティの削減 {#reducing-volatility}

ボラティリティが高い場合は、以下を調査できます:

1. 安定した、焦点を絞った製品チームを維持します。

   チームメンバーが多くのワークストリームに時間を分散し、あるスプリントから次のスプリントまで同じチームとワークストリームに一貫して割り当てられていないとします。そのような場合、ベロシティの変動につながる可能性があります。
1. ストーリーをより小さな垂直スライスに分割します。

   最近完了したストーリーを見て、ストーリーポイントの範囲を評価します。5ポイントのストーリーは、1ポイントのストーリーと比較して、はるかに複雑で未知数が多いものです。チームとして、ウェイトが1つまたは2つのストーリーのみをイテレーションにプルするように意図的に行ってください。大きなストーリーのサイズを削減する方法がわからない場合は、[エンジニアリングスパイク](https://www.jamesshore.com/v2/books/aoad1/spike_solutions)の実施を検討してください。実装パスを理解し、チームがストーリーに段階的かつ反復的にアプローチする方法を特定します。
1. プロセスのボトルネックがある場所を理解します。

   スプリントでストーリーが進行するワークフロー段階を反映する[カスタムバリューストリーム分析レポート](../../user/group/value_stream_analytics/_index.md#with-custom-stages)を作成できます。このレポートは、スプリントサイクル中に最も時間がかかる特定のワークフロー段階で、レトロスペクティブでのディスカッションに焦点を当てるのに役立ちます。

## 関連トピック {#related-topics}

- [チュートリアル: チームスタンドアップ用のイシューボードをセットアップする](../boards_for_standups/_index.md)
