/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import com.headius.invokebinder.SmartBinder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.function.Supplier;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.MethodArgs2;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.StringSupport;

public class HandleMethod
extends DynamicMethod
implements MethodArgs2,
Cloneable {
    private Supplier<MethodHandle> maker0;
    private Supplier<MethodHandle> maker1;
    private Supplier<MethodHandle> maker2;
    private Supplier<MethodHandle> maker3;
    private Supplier<MethodHandle> maker4;
    private MethodHandle target0;
    private MethodHandle target1;
    private MethodHandle target2;
    private MethodHandle target3;
    private MethodHandle target4;
    private volatile boolean initialized0;
    private volatile boolean initialized1;
    private volatile boolean initialized2;
    private volatile boolean initialized3;
    private volatile boolean initialized4;
    private final int min;
    private final int max;
    private final String parameterDesc;
    private final Signature signature;
    private final boolean builtin;
    private final boolean notImplemented;
    private static final com.headius.invokebinder.Signature ARITY_0 = com.headius.invokebinder.Signature.from(IRubyObject.class, Helpers.arrayOf(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, Block.class), "context", "self", "selfType", "name", "block");
    private static final com.headius.invokebinder.Signature ARITY_1 = ARITY_0.insertArg(4, "arg0", IRubyObject.class);
    private static final com.headius.invokebinder.Signature ARITY_2 = ARITY_1.insertArg(5, "arg1", IRubyObject.class);
    private static final com.headius.invokebinder.Signature ARITY_3 = ARITY_2.insertArg(6, "arg2", IRubyObject.class);
    private static final com.headius.invokebinder.Signature[] ARITIES = new com.headius.invokebinder.Signature[]{ARITY_0, ARITY_1, ARITY_2, ARITY_3};

    public HandleMethod(RubyModule implementationClass, Visibility visibility, String name2, long encodedSignature, boolean builtin, boolean notImplemented, String parameterDesc, int min2, int max2, Supplier<MethodHandle> maker0, Supplier<MethodHandle> maker1, Supplier<MethodHandle> maker2, Supplier<MethodHandle> maker3, Supplier<MethodHandle> maker4) {
        super(implementationClass, visibility, name2);
        this.signature = Signature.decode(encodedSignature);
        this.builtin = builtin;
        this.notImplemented = notImplemented;
        this.parameterDesc = parameterDesc;
        this.min = min2;
        this.max = max2;
        this.maker0 = maker0;
        this.maker1 = maker1;
        this.maker2 = maker2;
        this.maker3 = maker3;
        this.maker4 = maker4;
    }

    @Override
    @Deprecated(since="9.3.0.0")
    public Arity getArity() {
        return this.signature.arity();
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean isBuiltin() {
        return this.builtin;
    }

    @Override
    public boolean isNotImplemented() {
        return this.notImplemented;
    }

    @Override
    public boolean isNative() {
        return true;
    }

    private MethodHandle ensureTarget0() {
        MethodHandle target0;
        if (!this.initialized0) {
            Supplier<MethodHandle> maker0 = this.maker0;
            target0 = maker0 == null ? this.adaptSpecificToVarargs(this.ensureTarget4(), 0) : maker0.get();
            this.target0 = target0;
            this.maker0 = null;
            this.initialized0 = true;
        } else {
            target0 = this.target0;
        }
        return target0;
    }

    private MethodHandle ensureTarget1() {
        MethodHandle target1;
        if (!this.initialized1) {
            Supplier<MethodHandle> maker1 = this.maker1;
            target1 = maker1 == null ? this.adaptSpecificToVarargs(this.ensureTarget4(), 1) : maker1.get();
            this.target1 = target1;
            this.maker1 = null;
            this.initialized1 = true;
        } else {
            target1 = this.target1;
        }
        return target1;
    }

    private MethodHandle ensureTarget2() {
        MethodHandle target2;
        if (!this.initialized2) {
            Supplier<MethodHandle> maker2 = this.maker2;
            target2 = maker2 == null ? this.adaptSpecificToVarargs(this.ensureTarget4(), 2) : maker2.get();
            this.target2 = target2;
            this.maker2 = null;
            this.initialized2 = true;
        } else {
            target2 = this.target2;
        }
        return target2;
    }

    private MethodHandle ensureTarget3() {
        MethodHandle target3;
        if (!this.initialized3) {
            Supplier<MethodHandle> maker3 = this.maker3;
            target3 = maker3 == null ? this.adaptSpecificToVarargs(this.ensureTarget4(), 3) : maker3.get();
            this.target3 = target3;
            this.maker3 = null;
            this.initialized3 = true;
        } else {
            target3 = this.target3;
        }
        return target3;
    }

    private MethodHandle ensureTarget4() {
        if (!this.initialized4) {
            Supplier<MethodHandle> maker4 = this.maker4;
            MethodHandle target4 = maker4 == null ? null : maker4.get();
            this.target4 = target4;
            this.initialized4 = true;
            this.maker4 = null;
        }
        return this.target4;
    }

    private MethodHandle adaptSpecificToVarargs(MethodHandle varargs, int arity2) {
        if (arity2 == 0) {
            return MethodHandles.insertArguments(varargs, 4, new Object[]{IRubyObject.NULL_ARRAY});
        }
        return SmartBinder.from(ARITIES[arity2]).permute("context", "self", "type", "name", "block", "arg.*").collect("args", "arg.*").permute("context", "self", "type", "name", "args", "block").invoke(varargs).handle();
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        try {
            MethodHandle target4 = this.ensureTarget4();
            if (target4 != null) {
                return target4.invokeExact(context, self2, clazz, name2, args2, block);
            }
            int arity2 = Arity.checkArgumentCount(context, args2.length, this.min, this.max);
            switch (args2.length) {
                case 0: {
                    return this.call(context, self2, clazz, name2, block);
                }
                case 1: {
                    return this.call(context, self2, clazz, name2, args2[0], block);
                }
                case 2: {
                    return this.call(context, self2, clazz, name2, args2[0], args2[1], block);
                }
                case 3: {
                    return this.call(context, self2, clazz, name2, args2[0], args2[1], args2[2], block);
                }
            }
            throw new RuntimeException("invalid arity for call: " + arity2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        MethodHandle target0 = this.ensureTarget0();
        if (target0 == null) {
            return this.call(context, self2, clazz, name2, IRubyObject.NULL_ARRAY, block);
        }
        try {
            return target0.invokeExact(context, self2, clazz, name2, block);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        MethodHandle target1 = this.ensureTarget1();
        if (target1 == null) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0}, block);
        }
        try {
            return target1.invokeExact(context, self2, clazz, name2, arg0, block);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        MethodHandle target2 = this.ensureTarget2();
        if (target2 == null) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1}, block);
        }
        try {
            return target2.invokeExact(context, self2, clazz, name2, arg0, arg1, block);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        MethodHandle target3 = this.ensureTarget3();
        if (target3 == null) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1, arg2}, block);
        }
        try {
            return target3.invokeExact(context, self2, clazz, name2, arg0, arg1, arg2, block);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public DynamicMethod dup() {
        return new HandleMethod(this.implementationClass, this.getVisibility(), this.name, this.signature.encode(), this.builtin, this.notImplemented, this.parameterDesc, this.min, this.max, this.maker0, this.maker1, this.maker2, this.maker3, this.maker4);
    }

    @Override
    public String[] getParameterList() {
        if (this.parameterDesc != null && this.parameterDesc.length() > 0) {
            return StringSupport.split(this.parameterDesc, ';').toArray(StringSupport.EMPTY_STRING_ARRAY);
        }
        return StringSupport.EMPTY_STRING_ARRAY;
    }

    public MethodHandle getHandle(int arity2) {
        switch (arity2) {
            case -1: {
                return this.ensureTarget4();
            }
            case 0: {
                return this.ensureTarget0();
            }
            case 1: {
                return this.ensureTarget1();
            }
            case 2: {
                return this.ensureTarget2();
            }
            case 3: {
                return this.ensureTarget3();
            }
        }
        return null;
    }
}

