/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.kafka.connect.runtime.isolation.LoaderSwap;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginScanResult;
import org.apache.kafka.connect.runtime.isolation.PluginScanner;
import org.apache.kafka.connect.runtime.isolation.PluginSource;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.connect.runtime.isolation.PluginUtils;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionScanner
extends PluginScanner {
    private static final Logger log = LoggerFactory.getLogger(ReflectionScanner.class);

    private static <T> String versionFor(Class<? extends T> pluginKlass) throws ReflectiveOperationException {
        T pluginImpl = pluginKlass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return ReflectionScanner.versionFor(pluginImpl);
    }

    @Override
    protected PluginScanResult scanPlugins(PluginSource source) {
        ClassGraph classGraphBuilder = new ClassGraph().overrideClassLoaders(this.classLoaderOrder(source)).enableExternalClasses().enableClassInfo();
        try (ScanResult classGraph = classGraphBuilder.scan();){
            PluginScanResult pluginScanResult = new PluginScanResult(this.getPluginDesc(classGraph, PluginType.SINK, source), this.getPluginDesc(classGraph, PluginType.SOURCE, source), this.getPluginDesc(classGraph, PluginType.CONVERTER, source), this.getPluginDesc(classGraph, PluginType.HEADER_CONVERTER, source), this.getTransformationPluginDesc(source, classGraph), this.getPredicatePluginDesc(source, classGraph), this.getServiceLoaderPluginDesc(PluginType.CONFIGPROVIDER, source), this.getServiceLoaderPluginDesc(PluginType.REST_EXTENSION, source), this.getServiceLoaderPluginDesc(PluginType.CONNECTOR_CLIENT_CONFIG_OVERRIDE_POLICY, source));
            return pluginScanResult;
        }
    }

    private SortedSet<PluginDesc<Predicate<?>>> getPredicatePluginDesc(PluginSource source, ScanResult classGraph) {
        return this.getPluginDesc(classGraph, PluginType.PREDICATE, source);
    }

    private SortedSet<PluginDesc<Transformation<?>>> getTransformationPluginDesc(PluginSource source, ScanResult classGraph) {
        return this.getPluginDesc(classGraph, PluginType.TRANSFORMATION, source);
    }

    private ClassLoader[] classLoaderOrder(PluginSource source) {
        ArrayList<ClassLoader> classLoaderOrder = new ArrayList<ClassLoader>();
        for (ClassLoader cl = source.loader(); cl != null; cl = cl.getParent()) {
            classLoaderOrder.add(cl);
        }
        return classLoaderOrder.toArray(new ClassLoader[0]);
    }

    private <T> SortedSet<PluginDesc<T>> getPluginDesc(ScanResult classGraph, PluginType type, PluginSource source) {
        ClassInfoList plugins;
        Class<?> klass = type.superClass();
        try {
            plugins = klass.isInterface() ? classGraph.getClassesImplementing(klass.getName()) : classGraph.getSubclasses(klass.getName());
        }
        catch (Exception e) {
            log.debug("Reflections scanner could not find any {} in {} for URLs: {}", new Object[]{type, source, source.urls(), e});
            return Collections.emptySortedSet();
        }
        TreeSet<PluginDesc<T>> result = new TreeSet<PluginDesc<T>>();
        for (Class pluginKlass : plugins.getStandardClasses().loadClasses(klass, true)) {
            if (!PluginUtils.isConcrete(pluginKlass)) {
                log.debug("Skipping {} in {} as it is not concrete implementation", (Object)pluginKlass, (Object)source);
                continue;
            }
            if (pluginKlass.getClassLoader() != source.loader()) {
                log.debug("{} from other classloader {} is visible from {}, excluding to prevent isolated loading", new Object[]{pluginKlass, pluginKlass.getClassLoader(), source});
                continue;
            }
            try {
                LoaderSwap loaderSwap = this.withClassLoader(source.loader());
                try {
                    result.add(this.pluginDesc(pluginKlass, ReflectionScanner.versionFor(pluginKlass), type, source));
                }
                finally {
                    if (loaderSwap == null) continue;
                    loaderSwap.close();
                }
            }
            catch (LinkageError | ReflectiveOperationException e) {
                log.error("Failed to discover {} in {}: Unable to instantiate {}{}", new Object[]{type.simpleName(), source, pluginKlass.getSimpleName(), ReflectionScanner.reflectiveErrorDescription(e), e});
            }
        }
        return result;
    }
}

