/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.creator;

import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.SimpleTyped;
import io.quarkus.gizmo2.creator.AbstractMethodCreator;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ConstructorCreator;
import io.quarkus.gizmo2.creator.InstanceFieldCreator;
import io.quarkus.gizmo2.creator.InstanceMethodCreator;
import io.quarkus.gizmo2.creator.ModifierFlag;
import io.quarkus.gizmo2.creator.TypeCreator;
import io.quarkus.gizmo2.creator.TypeParameterizedCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.EqualsHashCodeToStringGenerator;
import io.quarkus.gizmo2.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassCreator
extends TypeCreator,
SimpleTyped,
TypeParameterizedCreator {
    public ClassDesc superClass();

    public void extends_(GenericType.OfClass var1);

    public void extends_(ClassDesc var1);

    public void implements_(GenericType.OfClass var1);

    public void implements_(ClassDesc var1);

    default public void implements_(Class<?> interface_) {
        if (!interface_.isInterface()) {
            throw new IllegalArgumentException("Only interfaces may be implemented");
        }
        this.implements_(Util.classDesc(interface_));
    }

    default public void extends_(Class<?> clazz) {
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Classes may only extend classes");
        }
        this.extends_(Util.classDesc(clazz));
    }

    public FieldDesc field(String var1, Consumer<InstanceFieldCreator> var2);

    default public FieldDesc field(String name, Const initial) {
        return this.field(name, (InstanceFieldCreator ifc) -> {
            ifc.setType(initial.type());
            ifc.setInitial(initial);
        });
    }

    public MethodDesc method(String var1, Consumer<InstanceMethodCreator> var2);

    default public MethodDesc method(String name, MethodTypeDesc type, Consumer<InstanceMethodCreator> builder) {
        return this.method(name, (InstanceMethodCreator imc) -> {
            imc.setType(type);
            builder.accept((InstanceMethodCreator)imc);
        });
    }

    default public MethodDesc method(MethodDesc desc, Consumer<InstanceMethodCreator> builder) {
        return this.method(desc.name(), (MethodTypeDesc)desc.type(), builder);
    }

    public MethodDesc abstractMethod(String var1, Consumer<AbstractMethodCreator> var2);

    default public MethodDesc abstractMethod(String name, MethodTypeDesc type, Consumer<AbstractMethodCreator> builder) {
        return this.abstractMethod(name, (AbstractMethodCreator imc) -> {
            imc.setType(type);
            builder.accept((AbstractMethodCreator)imc);
        });
    }

    default public MethodDesc abstractMethod(MethodDesc desc, Consumer<AbstractMethodCreator> builder) {
        return this.abstractMethod(desc.name(), (MethodTypeDesc)desc.type(), builder);
    }

    public MethodDesc nativeMethod(String var1, Consumer<AbstractMethodCreator> var2);

    default public MethodDesc nativeMethod(String name, MethodTypeDesc type, Consumer<AbstractMethodCreator> builder) {
        return this.nativeMethod(name, (AbstractMethodCreator imc) -> {
            imc.setType(type);
            builder.accept((AbstractMethodCreator)imc);
        });
    }

    default public MethodDesc nativeMethod(MethodDesc desc, Consumer<AbstractMethodCreator> builder) {
        return this.nativeMethod(desc.name(), (MethodTypeDesc)desc.type(), builder);
    }

    public MethodDesc staticNativeMethod(String var1, Consumer<AbstractMethodCreator> var2);

    default public MethodDesc staticNativeMethod(String name, MethodTypeDesc type, Consumer<AbstractMethodCreator> builder) {
        return this.staticNativeMethod(name, (AbstractMethodCreator imc) -> {
            imc.setType(type);
            builder.accept((AbstractMethodCreator)imc);
        });
    }

    default public MethodDesc staticNativeMethod(MethodDesc desc, Consumer<AbstractMethodCreator> builder) {
        return this.staticNativeMethod(desc.name(), (MethodTypeDesc)desc.type(), builder);
    }

    public ConstructorDesc constructor(Consumer<ConstructorCreator> var1);

    default public ConstructorDesc constructor(MethodTypeDesc type, Consumer<ConstructorCreator> builder) {
        return this.constructor(imc -> {
            imc.setType(type);
            builder.accept((ConstructorCreator)imc);
        });
    }

    default public ConstructorDesc constructor(ConstructorDesc desc, Consumer<ConstructorCreator> builder) {
        return this.constructor(desc.type(), builder);
    }

    default public ConstructorDesc defaultConstructor() {
        ConstructorDesc superCtor = ConstructorDesc.of(this.superClass());
        return this.constructor(superCtor, (ConstructorCreator cc) -> {
            cc.public_();
            cc.body(bc -> {
                bc.invokeSpecial(superCtor, (Expr)this.this_(), new Expr[0]);
                bc.return_();
            });
        });
    }

    public void instanceInitializer(Consumer<BlockCreator> var1);

    default public void abstract_() {
        this.addFlag(ModifierFlag.ABSTRACT);
    }

    default public void generateEquals(List<FieldDesc> fields) {
        new EqualsHashCodeToStringGenerator(this, fields).generateEquals();
    }

    default public void generateEqualsAndHashCode(List<FieldDesc> fields) {
        EqualsHashCodeToStringGenerator generator = new EqualsHashCodeToStringGenerator(this, fields);
        generator.generateEquals();
        generator.generateHashCode();
    }

    default public void generateToString(List<FieldDesc> fields) {
        new EqualsHashCodeToStringGenerator(this, fields).generateToString();
    }
}

