/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.stats;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.replication.action.stats.FollowerNodeStatsResponse;
import org.opensearch.replication.metadata.state.ReplicationStateMetadata;
import org.opensearch.replication.task.shard.FollowerShardMetric;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 D2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003:\u0001DB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B=\b\u0016\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b\u0012\u0010\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0006\u0010\u0010J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\"\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0010\u0010=\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u000bH\u0014J\u001a\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J\b\u0010C\u001a\u00020\u001aH\u0016R&\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R&\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00140\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u0018R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001a\u0010,\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010&\"\u0004\b.\u0010(R\u001a\u0010/\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010&\"\u0004\b1\u0010(R\u001a\u00102\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010&\"\u0004\b4\u0010(R\u001a\u00105\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010&\"\u0004\b7\u0010(\u00a8\u0006E"}, d2={"Lorg/opensearch/replication/action/stats/FollowerStatsResponse;", "Lorg/opensearch/action/support/nodes/BaseNodesResponse;", "Lorg/opensearch/replication/action/stats/FollowerNodeStatsResponse;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "<init>", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "clusterName", "Lorg/opensearch/cluster/ClusterName;", "followerNodeResponse", "", "failures", "Lorg/opensearch/action/FailedNodeException;", "metadata", "Lorg/opensearch/replication/metadata/state/ReplicationStateMetadata;", "(Lorg/opensearch/cluster/ClusterName;Ljava/util/List;Ljava/util/List;Lorg/opensearch/replication/metadata/state/ReplicationStateMetadata;)V", "shardStats", "", "Lorg/opensearch/core/index/shard/ShardId;", "Lorg/opensearch/replication/task/shard/FollowerShardMetric$FollowerStats;", "getShardStats", "()Ljava/util/Map;", "setShardStats", "(Ljava/util/Map;)V", "indexStats", "", "getIndexStats", "setIndexStats", "stats", "Lorg/opensearch/replication/task/shard/FollowerShardMetric$FollowerStatsFragment;", "getStats", "()Lorg/opensearch/replication/task/shard/FollowerShardMetric$FollowerStatsFragment;", "setStats", "(Lorg/opensearch/replication/task/shard/FollowerShardMetric$FollowerStatsFragment;)V", "pausedIndices", "", "getPausedIndices", "()I", "setPausedIndices", "(I)V", "failedIndices", "getFailedIndices", "setFailedIndices", "bootstrappingIndices", "getBootstrappingIndices", "setBootstrappingIndices", "syncingIndices", "getSyncingIndices", "setSyncingIndices", "shardTaskCount", "getShardTaskCount", "setShardTaskCount", "indexTaskCount", "getIndexTaskCount", "setIndexTaskCount", "readNodesFrom", "writeNodesTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "leaderNodeRespons", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "toString", "Companion", "opensearch-cross-cluster-replication"})
public final class FollowerStatsResponse
extends BaseNodesResponse<FollowerNodeStatsResponse>
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<ShardId, FollowerShardMetric.FollowerStats> shardStats;
    @NotNull
    private Map<String, FollowerShardMetric.FollowerStats> indexStats;
    @NotNull
    private FollowerShardMetric.FollowerStatsFragment stats;
    private int pausedIndices;
    private int failedIndices;
    private int bootstrappingIndices;
    private int syncingIndices;
    private int shardTaskCount;
    private int indexTaskCount;
    private static final Logger log = LogManager.getLogger(FollowerStatsResponse.class);

    @NotNull
    public final Map<ShardId, FollowerShardMetric.FollowerStats> getShardStats() {
        return this.shardStats;
    }

    public final void setShardStats(@NotNull Map<ShardId, FollowerShardMetric.FollowerStats> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.shardStats = map;
    }

    @NotNull
    public final Map<String, FollowerShardMetric.FollowerStats> getIndexStats() {
        return this.indexStats;
    }

    public final void setIndexStats(@NotNull Map<String, FollowerShardMetric.FollowerStats> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.indexStats = map;
    }

    @NotNull
    public final FollowerShardMetric.FollowerStatsFragment getStats() {
        return this.stats;
    }

    public final void setStats(@NotNull FollowerShardMetric.FollowerStatsFragment followerStatsFragment) {
        Intrinsics.checkNotNullParameter((Object)followerStatsFragment, (String)"<set-?>");
        this.stats = followerStatsFragment;
    }

    public final int getPausedIndices() {
        return this.pausedIndices;
    }

    public final void setPausedIndices(int n) {
        this.pausedIndices = n;
    }

    public final int getFailedIndices() {
        return this.failedIndices;
    }

    public final void setFailedIndices(int n) {
        this.failedIndices = n;
    }

    public final int getBootstrappingIndices() {
        return this.bootstrappingIndices;
    }

    public final void setBootstrappingIndices(int n) {
        this.bootstrappingIndices = n;
    }

    public final int getSyncingIndices() {
        return this.syncingIndices;
    }

    public final void setSyncingIndices(int n) {
        this.syncingIndices = n;
    }

    public final int getShardTaskCount() {
        return this.shardTaskCount;
    }

    public final void setShardTaskCount(int n) {
        this.shardTaskCount = n;
    }

    public final int getIndexTaskCount() {
        return this.indexTaskCount;
    }

    public final void setIndexTaskCount(int n) {
        this.indexTaskCount = n;
    }

    public FollowerStatsResponse(@NotNull StreamInput inp) {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        super(inp);
        this.shardStats = new LinkedHashMap();
        this.indexStats = new LinkedHashMap();
        this.stats = new FollowerShardMetric.FollowerStatsFragment();
        Map map = inp.readMap(ShardId::new, FollowerShardMetric.FollowerStats::new);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"readMap(...)");
        this.shardStats = map;
    }

    /*
     * Enabled aggressive block sorting
     */
    public FollowerStatsResponse(@Nullable ClusterName clusterName, @Nullable List<FollowerNodeStatsResponse> followerNodeResponse, @Nullable List<? extends FailedNodeException> failures, @NotNull ReplicationStateMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        super(clusterName, followerNodeResponse, failures);
        this.shardStats = new LinkedHashMap();
        this.indexStats = new LinkedHashMap();
        this.stats = new FollowerShardMetric.FollowerStatsFragment();
        Set syncing = new LinkedHashSet();
        if (followerNodeResponse != null) {
            for (FollowerNodeStatsResponse response2 : followerNodeResponse) {
                this.shardStats.putAll(response2.getStats());
                for (Map.Entry<ShardId, FollowerShardMetric.FollowerStats> i : response2.getStats().entrySet()) {
                    String string = i.getKey().getIndexName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIndexName(...)");
                    syncing.add(string);
                    if (!this.indexStats.containsKey(i.getKey().getIndexName())) {
                        this.indexStats.put(i.getKey().getIndexName(), new FollowerShardMetric.FollowerStats(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 511, null));
                    }
                    FollowerShardMetric.FollowerStats followerStats = this.indexStats.get(i.getKey().getIndexName());
                    Intrinsics.checkNotNull((Object)followerStats);
                    followerStats.add(i.getValue());
                    this.stats.add(i.getValue());
                }
            }
        }
        int totalRunning = 0;
        Iterator<Map.Entry<String, Map<String, String>>> iterator = metadata.getReplicationDetails().entrySet().iterator();
        while (true) {
            block13: {
                int n;
                block12: {
                    if (!iterator.hasNext()) {
                        this.syncingIndices = syncing.size();
                        this.bootstrappingIndices = totalRunning - this.syncingIndices;
                        this.shardTaskCount = this.shardStats.size();
                        this.indexTaskCount = totalRunning;
                        return;
                    }
                    Map.Entry<String, Map<String, String>> entry = iterator.next();
                    String string = entry.getValue().get("REPLICATION_LAST_KNOWN_OVERALL_STATE");
                    if (string == null) continue;
                    switch (string.hashCode()) {
                        case -1941992146: {
                            if (string.equals("PAUSED")) break block12;
                            break block13;
                        }
                        case 2066319421: {
                            if (string.equals("FAILED")) break;
                            break block13;
                        }
                        case -2026200673: {
                            if (string.equals("RUNNING")) {
                                ++totalRunning;
                            }
                            break block13;
                        }
                    }
                    n = this.failedIndices;
                    this.failedIndices = n + 1;
                    continue;
                }
                n = this.pausedIndices;
                this.pausedIndices = n + 1;
            }
        }
    }

    @NotNull
    protected List<FollowerNodeStatsResponse> readNodesFrom(@NotNull StreamInput inp) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        List list = inp.readList(arg_0 -> FollowerStatsResponse.readNodesFrom$lambda$0(inp, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
        return list;
    }

    protected void writeNodesTo(@NotNull StreamOutput out, @Nullable List<FollowerNodeStatsResponse> leaderNodeRespons) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeList(leaderNodeRespons);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) throws IOException {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.startObject();
        builder.field("num_syncing_indices", this.syncingIndices);
        builder.field("num_bootstrapping_indices", this.bootstrappingIndices);
        builder.field("num_paused_indices", this.pausedIndices);
        builder.field("num_failed_indices", this.failedIndices);
        builder.field("num_shard_tasks", this.shardTaskCount);
        builder.field("num_index_tasks", this.indexTaskCount);
        this.stats.toXContent(builder, params);
        builder.field("index_stats").map(this.indexStats);
        builder.endObject();
        return builder;
    }

    @NotNull
    public String toString() {
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().prettyPrint();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"prettyPrint(...)");
        XContentBuilder builder = xContentBuilder;
        this.toXContent(builder, ToXContent.EMPTY_PARAMS);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final FollowerNodeStatsResponse readNodesFrom$lambda$0(StreamInput $inp, StreamInput it) {
        return new FollowerNodeStatsResponse($inp);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/replication/action/stats/FollowerStatsResponse$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

