/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

public enum BinaryOperatorType {
    ANY,
    BITWISE_AND,
    BITWISE_OR,
    EXCLUSIVE_OR,
    LOGICAL_AND,
    LOGICAL_OR,
    GREATER_THAN,
    GREATER_THAN_OR_EQUAL,
    LESS_THAN,
    LESS_THAN_OR_EQUAL,
    EQUALITY,
    INEQUALITY,
    ADD,
    SUBTRACT,
    MULTIPLY,
    DIVIDE,
    MODULUS,
    SHIFT_LEFT,
    SHIFT_RIGHT,
    UNSIGNED_SHIFT_RIGHT;


    public final boolean isLogical() {
        switch (this) {
            case LOGICAL_AND: 
            case LOGICAL_OR: {
                return true;
            }
        }
        return false;
    }

    public final boolean isCommutative() {
        switch (this) {
            case BITWISE_AND: 
            case BITWISE_OR: 
            case EXCLUSIVE_OR: 
            case EQUALITY: 
            case INEQUALITY: 
            case ADD: 
            case MULTIPLY: {
                return true;
            }
        }
        return false;
    }

    public final boolean isRelational() {
        switch (this) {
            case EQUALITY: 
            case INEQUALITY: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return true;
            }
        }
        return false;
    }

    public final boolean isArithmetic() {
        switch (this) {
            case ADD: 
            case MULTIPLY: 
            case SUBTRACT: 
            case DIVIDE: 
            case MODULUS: {
                return true;
            }
        }
        return false;
    }

    public final boolean isBitwise() {
        switch (this) {
            case BITWISE_AND: 
            case BITWISE_OR: 
            case EXCLUSIVE_OR: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case UNSIGNED_SHIFT_RIGHT: {
                return true;
            }
        }
        return false;
    }
}

