/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.buttons;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.Timer;
import net.sf.sdedit.ui.components.buttons.Activator;
import net.sf.sdedit.ui.components.buttons.ManagedAction;
import net.sf.sdedit.ui.components.configuration.ConfigurationAction;
import net.sf.sdedit.util.collection.OntoMap;

public class ActionManager
implements ActionListener {
    private Map<String, ManagedAction> actionMap;
    private Map<JComponent, Activator> activatorMap = new HashMap<JComponent, Activator>();
    private OntoMap<JComponent, String> actionNames;
    private Map<JComponent, String> originalTexts;
    private List<ConfigurationAction<?>> configurationActions = new LinkedList();
    private Map<String, Activator> overloadedActivators;
    private Timer timer;
    private boolean timeToEnable = false;

    public ActionManager() {
        this.actionNames = new OntoMap(LinkedList.class);
        this.actionMap = new HashMap<String, ManagedAction>();
        this.overloadedActivators = new HashMap<String, Activator>();
        this.originalTexts = new HashMap<JComponent, String>();
        this.timer = new Timer(250, this);
        this.timer.start();
    }

    private String getId(Action action) {
        String id = (String)action.getValue("ActionID");
        if (id != null) {
            return id;
        }
        return (String)action.getValue("Name");
    }

    private void _activateComponents() {
        for (Map.Entry<JComponent, Activator> entry : this.activatorMap.entrySet()) {
            JComponent comp = entry.getKey();
            Activator activator = entry.getValue();
            String actionName = this.actionNames.getImage(comp);
            if (actionName != null && this.overloadedActivators.containsKey(actionName)) {
                activator = this.overloadedActivators.get(actionName);
            }
            comp.setEnabled(activator.isEnabled());
        }
        for (ConfigurationAction configurationAction : this.configurationActions) {
            configurationAction.update();
        }
    }

    public synchronized void enableComponents() {
        this.timeToEnable = true;
        this.timer.restart();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        if (this.timeToEnable) {
            this._activateComponents();
            this.timeToEnable = false;
        }
    }

    public void registerButton(JComponent comp, Action action, Activator activator) {
        if (activator != null) {
            this.activatorMap.put(comp, activator);
        }
        if (action != null) {
            String name = this.getId(action);
            this.actionNames.add(comp, name);
        }
    }

    public void registerConfigurationAction(ConfigurationAction<?> action, AbstractButton button) {
        action.setButton(button);
        this.configurationActions.add(action);
    }

    public Action addAction(Action action) {
        String id = this.getId(action);
        ManagedAction managedAction = this.actionMap.get(id);
        if (managedAction == null) {
            managedAction = new ManagedAction(action);
            this.actionMap.put(id, managedAction);
        }
        return managedAction;
    }

    public void overload(Action overload, Activator activator) {
        String newText;
        String name = this.getId(overload);
        ManagedAction managedAction = this.actionMap.get(name);
        if (managedAction == null) {
            throw new IllegalArgumentException("There is no managed action with the name " + name);
        }
        managedAction.overload(overload);
        if (activator != null) {
            this.overloadedActivators.put(name, activator);
        }
        if ((newText = (String)overload.getValue("NewName")) != null) {
            for (JComponent comp : this.actionNames.getPreImages(name)) {
                AbstractButton button;
                if (!(comp instanceof AbstractButton) || (button = (AbstractButton)comp).getText() == null || button.getText().length() <= 0) continue;
                this.originalTexts.put(button, button.getText());
                button.setText(newText.replaceAll("&", ""));
            }
        }
    }

    public void unload(Action overload) {
        String id = this.getId(overload);
        ManagedAction managedAction = this.actionMap.get(id);
        if (managedAction == null) {
            throw new IllegalArgumentException("There is no managed action with the name " + id);
        }
        managedAction.unload();
        this.overloadedActivators.remove(id);
        for (JComponent comp : this.actionNames.getPreImages(id)) {
            AbstractButton button;
            if (!(comp instanceof AbstractButton) || (button = (AbstractButton)comp).getText() == null || button.getText().length() <= 0) continue;
            button.setText(this.originalTexts.get(button));
        }
    }
}

