/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkRegionOfInterestImageFilter_h
#define sitkRegionOfInterestImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class RegionOfInterestImageFilter
\brief Extract a region of interest from the input image.

This filter produces an output image of the same dimension as the input image. The user specifies the region of the input image that will be contained in the output image. The origin coordinates of the output images will be computed in such a way that if mapped to physical space, the output image will overlay the input image with perfect registration. In other words, a registration process between the output image and the input image will return an identity transform.

If you are interested in changing the dimension of the image, you may want to consider the ExtractImageFilter . For example for extracting a 2D image from a slice of a 3D image.

The region to extract is set using the method SetRegionOfInterest.

\see ExtractImageFilter
\sa itk::simple::RegionOfInterest for the procedural interface
\sa itk::RegionOfInterestImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT RegionOfInterestImageFilter : public ImageFilter {
    public:
      using Self = RegionOfInterestImageFilter;

      /** Destructor */
      virtual ~RegionOfInterestImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      RegionOfInterestImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = NonLabelPixelIDTypeList;
\

      /**
       * \brief Size in pixels of the region extracted.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSize ( std::vector<unsigned int> Size ) { this->m_Size = std::move(Size); return *this; }

      /**
       */
      std::vector<unsigned int> GetSize() const { return this->m_Size; }\

      /**
       * \brief Set the inclusive starting index of the region extracted.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetIndex ( std::vector<int> Index ) { this->m_Index = std::move(Index); return *this; }

      /**
       */
      std::vector<int> GetIndex() const { return this->m_Index; }

      /** Name of this class */
      std::string GetName() const { return std::string ("RegionOfInterestImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );


      /** Sets the region extracted by a single array of the starting indexes followed by the sizes in pixels. */
      void SetRegionOfInterest(const std::vector<unsigned int> & Region );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::vector<unsigned int>  m_Size{std::vector<unsigned int>(3, 1)};

      std::vector<int>  m_Index{std::vector<int>(3, 0)};


    };

    /**\
     * \brief Extract a region of interest from the input image.
     *
     * This function directly calls the execute method of RegionOfInterestImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::RegionOfInterestImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image RegionOfInterest ( const Image& image1, std::vector<unsigned int> size = std::vector<unsigned int>(3, 1), std::vector<int> index = std::vector<int>(3, 0) );

     /** @} */
}
#endif
