﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/AnalyticsIntentStageMetricName.h>
#include <aws/lexv2-models/model/AnalyticsMetricStatistic.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {

/**
 * <p>An object containing the results for an intent stage metric you
 * requested.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/AnalyticsIntentStageMetricResult">AWS
 * API Reference</a></p>
 */
class AnalyticsIntentStageMetricResult {
 public:
  AWS_LEXMODELSV2_API AnalyticsIntentStageMetricResult() = default;
  AWS_LEXMODELSV2_API AnalyticsIntentStageMetricResult(Aws::Utils::Json::JsonView jsonValue);
  AWS_LEXMODELSV2_API AnalyticsIntentStageMetricResult& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_LEXMODELSV2_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The metric that you requested.</p> <ul> <li> <p> <code>Count</code> – The
   * number of times the intent stage occurred.</p> </li> <li> <p>
   * <code>Success</code> – The number of times the intent stage succeeded.</p> </li>
   * <li> <p> <code>Failure</code> – The number of times the intent stage failed.</p>
   * </li> <li> <p> <code>Dropped</code> – The number of times the user dropped the
   * intent stage.</p> </li> <li> <p> <code>Retry</code> – The number of times the
   * bot tried to elicit a response from the user at this stage.</p> </li> </ul>
   */
  inline AnalyticsIntentStageMetricName GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  inline void SetName(AnalyticsIntentStageMetricName value) {
    m_nameHasBeenSet = true;
    m_name = value;
  }
  inline AnalyticsIntentStageMetricResult& WithName(AnalyticsIntentStageMetricName value) {
    SetName(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The summary statistic that you requested to calculate.</p> <ul> <li> <p>
   * <code>Sum</code> – The total count for the category you provide in
   * <code>name</code>.</p> </li> <li> <p> <code>Average</code> – The total count
   * divided by the number of intent stages in the category you provide in
   * <code>name</code>.</p> </li> <li> <p> <code>Max</code> – The highest count in
   * the category you provide in <code>name</code>.</p> </li> </ul>
   */
  inline AnalyticsMetricStatistic GetStatistic() const { return m_statistic; }
  inline bool StatisticHasBeenSet() const { return m_statisticHasBeenSet; }
  inline void SetStatistic(AnalyticsMetricStatistic value) {
    m_statisticHasBeenSet = true;
    m_statistic = value;
  }
  inline AnalyticsIntentStageMetricResult& WithStatistic(AnalyticsMetricStatistic value) {
    SetStatistic(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value of the summary statistic for the metric that you requested.</p>
   */
  inline double GetValue() const { return m_value; }
  inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
  inline void SetValue(double value) {
    m_valueHasBeenSet = true;
    m_value = value;
  }
  inline AnalyticsIntentStageMetricResult& WithValue(double value) {
    SetValue(value);
    return *this;
  }
  ///@}
 private:
  AnalyticsIntentStageMetricName m_name{AnalyticsIntentStageMetricName::NOT_SET};

  AnalyticsMetricStatistic m_statistic{AnalyticsMetricStatistic::NOT_SET};

  double m_value{0.0};
  bool m_nameHasBeenSet = false;
  bool m_statisticHasBeenSet = false;
  bool m_valueHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
