﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/TaskRunProperties.h>
#include <aws/glue/model/TaskStatusType.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {
class GetMLTaskRunResult {
 public:
  AWS_GLUE_API GetMLTaskRunResult() = default;
  AWS_GLUE_API GetMLTaskRunResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GLUE_API GetMLTaskRunResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique identifier of the task run.</p>
   */
  inline const Aws::String& GetTransformId() const { return m_transformId; }
  template <typename TransformIdT = Aws::String>
  void SetTransformId(TransformIdT&& value) {
    m_transformIdHasBeenSet = true;
    m_transformId = std::forward<TransformIdT>(value);
  }
  template <typename TransformIdT = Aws::String>
  GetMLTaskRunResult& WithTransformId(TransformIdT&& value) {
    SetTransformId(std::forward<TransformIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique run identifier associated with this run.</p>
   */
  inline const Aws::String& GetTaskRunId() const { return m_taskRunId; }
  template <typename TaskRunIdT = Aws::String>
  void SetTaskRunId(TaskRunIdT&& value) {
    m_taskRunIdHasBeenSet = true;
    m_taskRunId = std::forward<TaskRunIdT>(value);
  }
  template <typename TaskRunIdT = Aws::String>
  GetMLTaskRunResult& WithTaskRunId(TaskRunIdT&& value) {
    SetTaskRunId(std::forward<TaskRunIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status for this task run.</p>
   */
  inline TaskStatusType GetStatus() const { return m_status; }
  inline void SetStatus(TaskStatusType value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline GetMLTaskRunResult& WithStatus(TaskStatusType value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The names of the log groups that are associated with the task run.</p>
   */
  inline const Aws::String& GetLogGroupName() const { return m_logGroupName; }
  template <typename LogGroupNameT = Aws::String>
  void SetLogGroupName(LogGroupNameT&& value) {
    m_logGroupNameHasBeenSet = true;
    m_logGroupName = std::forward<LogGroupNameT>(value);
  }
  template <typename LogGroupNameT = Aws::String>
  GetMLTaskRunResult& WithLogGroupName(LogGroupNameT&& value) {
    SetLogGroupName(std::forward<LogGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of properties that are associated with the task run.</p>
   */
  inline const TaskRunProperties& GetProperties() const { return m_properties; }
  template <typename PropertiesT = TaskRunProperties>
  void SetProperties(PropertiesT&& value) {
    m_propertiesHasBeenSet = true;
    m_properties = std::forward<PropertiesT>(value);
  }
  template <typename PropertiesT = TaskRunProperties>
  GetMLTaskRunResult& WithProperties(PropertiesT&& value) {
    SetProperties(std::forward<PropertiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The error strings that are associated with the task run.</p>
   */
  inline const Aws::String& GetErrorString() const { return m_errorString; }
  template <typename ErrorStringT = Aws::String>
  void SetErrorString(ErrorStringT&& value) {
    m_errorStringHasBeenSet = true;
    m_errorString = std::forward<ErrorStringT>(value);
  }
  template <typename ErrorStringT = Aws::String>
  GetMLTaskRunResult& WithErrorString(ErrorStringT&& value) {
    SetErrorString(std::forward<ErrorStringT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time when this task run started.</p>
   */
  inline const Aws::Utils::DateTime& GetStartedOn() const { return m_startedOn; }
  template <typename StartedOnT = Aws::Utils::DateTime>
  void SetStartedOn(StartedOnT&& value) {
    m_startedOnHasBeenSet = true;
    m_startedOn = std::forward<StartedOnT>(value);
  }
  template <typename StartedOnT = Aws::Utils::DateTime>
  GetMLTaskRunResult& WithStartedOn(StartedOnT&& value) {
    SetStartedOn(std::forward<StartedOnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time when this task run was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedOn() const { return m_lastModifiedOn; }
  template <typename LastModifiedOnT = Aws::Utils::DateTime>
  void SetLastModifiedOn(LastModifiedOnT&& value) {
    m_lastModifiedOnHasBeenSet = true;
    m_lastModifiedOn = std::forward<LastModifiedOnT>(value);
  }
  template <typename LastModifiedOnT = Aws::Utils::DateTime>
  GetMLTaskRunResult& WithLastModifiedOn(LastModifiedOnT&& value) {
    SetLastModifiedOn(std::forward<LastModifiedOnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time when this task run was completed.</p>
   */
  inline const Aws::Utils::DateTime& GetCompletedOn() const { return m_completedOn; }
  template <typename CompletedOnT = Aws::Utils::DateTime>
  void SetCompletedOn(CompletedOnT&& value) {
    m_completedOnHasBeenSet = true;
    m_completedOn = std::forward<CompletedOnT>(value);
  }
  template <typename CompletedOnT = Aws::Utils::DateTime>
  GetMLTaskRunResult& WithCompletedOn(CompletedOnT&& value) {
    SetCompletedOn(std::forward<CompletedOnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The amount of time (in seconds) that the task run consumed resources.</p>
   */
  inline int GetExecutionTime() const { return m_executionTime; }
  inline void SetExecutionTime(int value) {
    m_executionTimeHasBeenSet = true;
    m_executionTime = value;
  }
  inline GetMLTaskRunResult& WithExecutionTime(int value) {
    SetExecutionTime(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetMLTaskRunResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_transformId;

  Aws::String m_taskRunId;

  TaskStatusType m_status{TaskStatusType::NOT_SET};

  Aws::String m_logGroupName;

  TaskRunProperties m_properties;

  Aws::String m_errorString;

  Aws::Utils::DateTime m_startedOn{};

  Aws::Utils::DateTime m_lastModifiedOn{};

  Aws::Utils::DateTime m_completedOn{};

  int m_executionTime{0};

  Aws::String m_requestId;
  bool m_transformIdHasBeenSet = false;
  bool m_taskRunIdHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_logGroupNameHasBeenSet = false;
  bool m_propertiesHasBeenSet = false;
  bool m_errorStringHasBeenSet = false;
  bool m_startedOnHasBeenSet = false;
  bool m_lastModifiedOnHasBeenSet = false;
  bool m_completedOnHasBeenSet = false;
  bool m_executionTimeHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
