﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoTRequest.h>
#include <aws/iot/IoT_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace IoT {
namespace Model {

/**
 */
class CreateProvisioningTemplateVersionRequest : public IoTRequest {
 public:
  AWS_IOT_API CreateProvisioningTemplateVersionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateProvisioningTemplateVersion"; }

  AWS_IOT_API Aws::String SerializePayload() const override;

  AWS_IOT_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The name of the provisioning template.</p>
   */
  inline const Aws::String& GetTemplateName() const { return m_templateName; }
  inline bool TemplateNameHasBeenSet() const { return m_templateNameHasBeenSet; }
  template <typename TemplateNameT = Aws::String>
  void SetTemplateName(TemplateNameT&& value) {
    m_templateNameHasBeenSet = true;
    m_templateName = std::forward<TemplateNameT>(value);
  }
  template <typename TemplateNameT = Aws::String>
  CreateProvisioningTemplateVersionRequest& WithTemplateName(TemplateNameT&& value) {
    SetTemplateName(std::forward<TemplateNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The JSON formatted contents of the provisioning template.</p>
   */
  inline const Aws::String& GetTemplateBody() const { return m_templateBody; }
  inline bool TemplateBodyHasBeenSet() const { return m_templateBodyHasBeenSet; }
  template <typename TemplateBodyT = Aws::String>
  void SetTemplateBody(TemplateBodyT&& value) {
    m_templateBodyHasBeenSet = true;
    m_templateBody = std::forward<TemplateBodyT>(value);
  }
  template <typename TemplateBodyT = Aws::String>
  CreateProvisioningTemplateVersionRequest& WithTemplateBody(TemplateBodyT&& value) {
    SetTemplateBody(std::forward<TemplateBodyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Sets a fleet provision template version as the default version.</p>
   */
  inline bool GetSetAsDefault() const { return m_setAsDefault; }
  inline bool SetAsDefaultHasBeenSet() const { return m_setAsDefaultHasBeenSet; }
  inline void SetSetAsDefault(bool value) {
    m_setAsDefaultHasBeenSet = true;
    m_setAsDefault = value;
  }
  inline CreateProvisioningTemplateVersionRequest& WithSetAsDefault(bool value) {
    SetSetAsDefault(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_templateName;

  Aws::String m_templateBody;

  bool m_setAsDefault{false};
  bool m_templateNameHasBeenSet = false;
  bool m_templateBodyHasBeenSet = false;
  bool m_setAsDefaultHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
