/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32C;
import java.util.zip.Checksum;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.AbstractObjectStream;
import opennlp.tools.util.ObjectStream;

public class ChecksumEventStream
extends AbstractObjectStream<Event> {
    private final Checksum checksum = new CRC32C();

    public ChecksumEventStream(ObjectStream<Event> eventStream) {
        super(eventStream);
    }

    @Override
    public Event read() throws IOException {
        Event event = (Event)super.read();
        if (event != null) {
            this.checksum.update(event.toString().getBytes(StandardCharsets.UTF_8));
        }
        return event;
    }

    public long calculateChecksum() {
        return this.checksum.getValue();
    }
}

