/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.timeline;

import java.util.concurrent.atomic.AtomicBoolean;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.TimeFormat;
import org.gephi.timeline.api.TimelineChart;
import org.gephi.timeline.api.TimelineModel;

public class TimelineModelImpl
implements TimelineModel {
    private final GraphModel graphModel;
    private final AtomicBoolean playing;
    private boolean enabled;
    private double customMin;
    private double customMax;
    private int playDelay;
    private double playStep;
    private TimelineModel.PlayMode playMode;
    private TimelineChart chart;
    private double previousMin;
    private double previousMax;
    private Interval interval;

    public TimelineModelImpl(GraphModel dynamicModel) {
        this.graphModel = dynamicModel;
        this.customMin = dynamicModel.getTimeBounds().getLow();
        this.customMax = dynamicModel.getTimeBounds().getHigh();
        this.previousMin = this.customMin;
        this.previousMax = this.customMax;
        this.playDelay = 100;
        this.playStep = 0.01;
        this.playing = new AtomicBoolean(false);
        this.playMode = TimelineModel.PlayMode.TWO_BOUNDS;
        this.interval = new Interval(this.customMin, this.customMax);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public double getMin() {
        return this.graphModel.getTimeBounds().getLow();
    }

    @Override
    public double getMax() {
        return this.graphModel.getTimeBounds().getHigh();
    }

    public double getPreviousMin() {
        return this.previousMin;
    }

    public void setPreviousMin(double previousMin) {
        this.previousMin = previousMin;
    }

    public double getPreviousMax() {
        return this.previousMax;
    }

    public void setPreviousMax(double previousMax) {
        this.previousMax = previousMax;
    }

    @Override
    public double getCustomMin() {
        return this.customMin;
    }

    public void setCustomMin(double customMin) {
        this.customMin = customMin;
    }

    @Override
    public double getCustomMax() {
        return this.customMax;
    }

    public void setCustomMax(double customMax) {
        this.customMax = customMax;
    }

    @Override
    public boolean hasCustomBounds() {
        Interval tm = this.graphModel.getTimeBounds();
        return this.customMax != tm.getHigh() || this.customMin != tm.getLow();
    }

    @Override
    public double getIntervalStart() {
        double vi = this.interval.getLow();
        if (Double.isInfinite(vi)) {
            return this.getCustomMin();
        }
        return vi;
    }

    @Override
    public double getIntervalEnd() {
        double vi = this.interval.getHigh();
        if (Double.isInfinite(vi)) {
            return this.getCustomMax();
        }
        return vi;
    }

    @Override
    public TimeFormat getTimeFormat() {
        return this.graphModel.getTimeFormat();
    }

    public void setInterval(double start, double end) {
        this.interval = new Interval(start, end);
    }

    @Override
    public boolean hasValidBounds() {
        Interval i = this.graphModel.getTimeBounds();
        return !Double.isInfinite(i.getLow()) && !Double.isInfinite(i.getHigh());
    }

    public GraphModel getGraphModel() {
        return this.graphModel;
    }

    @Override
    public boolean isPlaying() {
        return this.playing.get();
    }

    public void setPlaying(boolean playing) {
        this.playing.set(playing);
    }

    @Override
    public int getPlayDelay() {
        return this.playDelay;
    }

    public void setPlayDelay(int playDelay) {
        this.playDelay = playDelay;
    }

    @Override
    public double getPlayStep() {
        return this.playStep;
    }

    public void setPlayStep(double playStep) {
        this.playStep = playStep;
    }

    @Override
    public TimelineModel.PlayMode getPlayMode() {
        return this.playMode;
    }

    public void setPlayMode(TimelineModel.PlayMode playMode) {
        this.playMode = playMode;
    }

    @Override
    public TimelineChart getChart() {
        return this.chart;
    }

    public void setChart(TimelineChart chart) {
        this.chart = chart;
    }
}

