# frozen_string_literal: true

class CreateKnowledgeGraphNamespaceForeignKey < Gitlab::Database::Migration[2.3]
  include Gitlab::Database::PartitioningMigrationHelpers::ForeignKeyHelpers

  disable_ddl_transaction!
  milestone '18.1'

  def up
    add_concurrent_partitioned_foreign_key :p_knowledge_graph_enabled_namespaces, :namespaces,
      column: :namespace_id, on_delete: :cascade
  end

  def down
    with_lock_retries do
      remove_foreign_key :p_knowledge_graph_enabled_namespaces, column: :namespace_id
    end
  end
end
