---
stage: GitLab Dedicated
group: Environment Automation
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: スケジュールされたメンテナンスウィンドウ、緊急時の手順、およびGitLab Dedicatedインスタンスの連絡先管理。
title: GitLab Dedicatedのメンテナンス運用
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab Dedicated

{{< /details >}}

GitLab Dedicatedは、スケジュールされた毎週のウィンドウ中に、セキュリティ、信頼性、および最適なパフォーマンスを確保するために、インスタンスの定期的なメンテナンスを提供します。

## メンテナンス時間枠 {#maintenance-windows}

メンテナンスは、標準の勤務時間外にスケジュールされた毎週のウィンドウ中に実行されます。オンボーディング中にメンテナンスウィンドウを選択できます。これは、インスタンスの作成後に変更できません。

### メンテナンスウィンドウのスケジュール {#maintenance-window-schedule}

| 地域                          | 日           | 時間 (UTC) |
| ------------------------------- | ------------- | ---------- |
| アジア太平洋                    | 水曜日     | 午後1:00～午後5:00 |
| ヨーロッパ、中東、アフリカ | 火曜日       | 午前1:00～午前5:00 |
| 南北アメリカ (オプション1)             | 火曜日       | 午前7:00～午前11:00 |
| 南北アメリカ (オプション2)             | 日曜日～月曜日 | 午後9:00～午前1:00 |

割り当てられたメンテナンスウィンドウを表示するには、[スイッチボード](tenant_overview.md)に移動します。

スケジュールされたメンテナンスウィンドウ中に、次のタスクが実行される場合があります:

- アプリケーションおよびオペレーティングシステムのソフトウェアパッチとアップグレード
- オペレーティングシステムの再起動
- インフラストラクチャのアップグレード
- セキュリティと可用性の強化
- 機能拡張

### メンテナンス中のアクセス {#access-during-maintenance}

メンテナンスウィンドウの全期間でダウンタイムが発生するとは限りません。通常、メンテナンスウィンドウの最初の半分に、コンピューティングリソースがアップグレード後に再起動すると、短いサービスのインターフェースの中断（1分未満）が発生する場合があります。

長時間実行されている接続は、この期間中に中断される可能性があります。中断を最小限に抑えるために、自動リカバリーや再試行などの戦略を実装できます。

より長いサービスの中断はまれです。拡張されたダウンタイムが予想される場合は、事前通知が届きます。

{{< alert type="note" >}}

スケジュールされたメンテナンスウィンドウ中のパフォーマンス低下またはダウンタイムは、システムのサービスレベルアベイラビリティ（SLA）に対してカウントされません。

{{< /alert >}}

### スケジューリングの例外 {#scheduling-exceptions}

本番環境変更ロック（PCL）は、主要な休日など、チームの可用性が低下する期間中のすべての本番環境変更を完全に一時停止することです。PCLは、サポートリソースが制限されている場合にシステムの安定性を確保します。

PCLの間、以下は一時停止されます:

- スイッチボードを使用した設定の変更
- コードのデプロイまたはインフラストラクチャの変更
- 自動メンテナンス
- 新しい顧客のオンボーディング

スケジュールされたアップグレード中にPCLがアクティブな場合、アップグレードはPCLが終了した後の最初のメンテナンスウィンドウに延期されます。

PCLがアクティブな場合、スイッチボードに通知バナーが表示されます。

## ゼロダウンタイムアップグレード {#zero-downtime-upgrades}

GitLab Dedicatedは、インスタンスの下位互換性を確保するために、ダウンタイムなしのアップグレードを提供します。インフラストラクチャの変更またはメンテナンスタスクにダウンタイムが必要ない場合は、アップグレード中にインスタンスを安全に使用し続けることができます。

バージョンアップグレード中にアセットの可用性を確保するには:

1. 各静的アセットには、コンテンツが変更されるときに変更される一意の名前があります。
1. ブラウザは各静的アセットをキャッシュします。
1. 同じブラウザからの各リクエストは、一時的に同じサーバーにルーティングされます。

アップグレードは通常、目立ちません。まれに、アップグレード中に一時的なインターフェースの不整合が発生する場合があります。これが発生した場合は、ページを更新して、視覚的な不整合を解決します。

{{< alert type="note" >}}

ネットワークにキャッシュプロキシを実装すると、アップグレード中のインターフェースの不整合のリスクがさらに軽減されます。

{{< /alert >}}

## 緊急メンテナンス {#emergency-maintenance}

緊急メンテナンスは、インスタンスが緊急のアクションを必要とする場合に開始されます。このメンテナンスは、スケジュールされたメンテナンスウィンドウ外で発生する可能性があり、延期することはできません。

たとえば、重大な（S1）セキュリティ脆弱性に緊急のパッチが必要な場合、インスタンスは安全なバージョンにアップグレードするための緊急メンテナンスを受けます。

緊急メンテナンス中、サービスのインターフェースへの影響を最小限に抑える一方で、安定性とセキュリティが優先されます。すべての変更は内部プロセスに従い、インスタンスに適用される前に、適切な内部レビューと承認を受けます。

可能な場合は事前通知を受け取り、イシューが解決された後に完全な詳細を受け取ります。サポートチーム:

- 追跡用のサポートチケットを作成します。
- メールの通知を運用担当者に送信します。
- すべてのコミュニケーションで顧客サクセスマネージャー（CSM）をコピーします。

これらの通知を確実に受信するには、[スイッチボード](configure_instance/users_notifications.md#manage-email-addresses-for-operational-contacts)で連絡先情報をレビューしてください。

## 関連トピック {#related-topics}

- [GitLab Dedicatedのリリースとバージョニング](releases.md)
- [テナント概要](tenant_overview.md)
- [GitLabのリリースおよびメンテナンスポリシー](../../policy/maintenance.md)
- [ゼロダウンタイムアップグレード](../../update/zero_downtime.md)
