/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildprocess.execution;

import org.gradle.BuildResult;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.exception.DefaultExceptionAnalyser;
import org.gradle.initialization.exception.ExceptionCollector;
import org.gradle.initialization.exception.MultipleBuildFailuresExceptionAnalyser;
import org.gradle.initialization.exception.StackTraceSanitizingExceptionAnalyser;
import org.gradle.internal.buildevents.BuildLogger;
import org.gradle.internal.buildevents.BuildLoggerFactory;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.exception.ExceptionAnalyser;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.problems.NoOpProblemDiagnosticsFactory;
import org.gradle.launcher.exec.BuildActionExecutor;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.problems.buildtree.ProblemDiagnosticsFactory;

public class SessionFailureReportingActionExecutor
implements BuildActionExecutor<BuildActionParameters, BuildRequestContext> {
    private final BuildActionExecutor<BuildActionParameters, BuildRequestContext> delegate;
    private final BuildLoggerFactory buildLoggerFactory;

    public SessionFailureReportingActionExecutor(BuildLoggerFactory buildLoggerFactory, BuildActionExecutor<BuildActionParameters, BuildRequestContext> delegate) {
        this.delegate = delegate;
        this.buildLoggerFactory = buildLoggerFactory;
    }

    public BuildActionResult execute(BuildAction action, BuildActionParameters actionParameters, BuildRequestContext requestContext) {
        try {
            return this.delegate.execute(action, (Object)actionParameters, (Object)requestContext);
        }
        catch (Throwable e) {
            MultipleBuildFailuresExceptionAnalyser exceptionAnalyser = new MultipleBuildFailuresExceptionAnalyser((ExceptionCollector)new DefaultExceptionAnalyser((ProblemDiagnosticsFactory)new NoOpProblemDiagnosticsFactory()));
            if (action.getStartParameter().getShowStacktrace() != ShowStacktrace.ALWAYS_FULL) {
                exceptionAnalyser = new StackTraceSanitizingExceptionAnalyser((ExceptionAnalyser)exceptionAnalyser);
            }
            RuntimeException failure = exceptionAnalyser.transform(e);
            BuildStartedTime buildStartedTime = BuildStartedTime.startingAt((long)requestContext.getStartTime());
            BuildLogger buildLogger = this.buildLoggerFactory.create(Logging.getLogger(SessionFailureReportingActionExecutor.class), (LoggingConfiguration)action.getStartParameter(), buildStartedTime, (BuildRequestMetaData)requestContext);
            buildLogger.buildFinished(new BuildResult(null, (Throwable)failure));
            buildLogger.logResult((Throwable)failure);
            return BuildActionResult.failed((RuntimeException)failure);
        }
    }
}

