/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.server.config.DelegationTokenManagerConfigs;

public class DelegationTokenManager {
    private static final String DEFAULT_HMAC_ALGORITHM = "HmacSHA512";
    public static final long ERROR_TIMESTAMP = -1L;
    private final DelegationTokenCache tokenCache;
    private final SecretKey secretKey;

    public DelegationTokenManager(DelegationTokenManagerConfigs config, DelegationTokenCache tokenCache) {
        this.tokenCache = tokenCache;
        byte[] keyBytes = config.tokenAuthEnabled() ? config.delegationTokenSecretKey().value().getBytes(StandardCharsets.UTF_8) : null;
        this.secretKey = keyBytes == null || keyBytes.length == 0 ? null : DelegationTokenManager.createSecretKey(keyBytes);
    }

    private static SecretKey createSecretKey(byte[] keyBytes) {
        return new SecretKeySpec(keyBytes, DEFAULT_HMAC_ALGORITHM);
    }

    public static byte[] createHmac(String tokenId, SecretKey secretKey) {
        try {
            Mac mac = Mac.getInstance(DEFAULT_HMAC_ALGORITHM);
            mac.init(secretKey);
            return mac.doFinal(tokenId.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key to HMAC computation", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating HMAC", e);
        }
    }

    private Map<String, ScramCredential> prepareScramCredentials(String hmacString) throws NoSuchAlgorithmException {
        HashMap<String, ScramCredential> scramCredentialMap = new HashMap<String, ScramCredential>();
        for (ScramMechanism mechanism : ScramMechanism.values()) {
            ScramFormatter formatter = new ScramFormatter(mechanism);
            scramCredentialMap.put(mechanism.mechanismName(), formatter.generateCredential(hmacString, mechanism.minIterations()));
        }
        return scramCredentialMap;
    }

    public void updateToken(DelegationToken token) throws NoSuchAlgorithmException {
        String hmacString = token.hmacAsBase64String();
        Map<String, ScramCredential> scramCredentialMap = this.prepareScramCredentials(hmacString);
        this.tokenCache.updateCache(token, scramCredentialMap);
    }

    public DelegationToken getDelegationToken(TokenInformation tokenInfo) {
        byte[] hmac = DelegationTokenManager.createHmac(tokenInfo.tokenId(), this.secretKey);
        return new DelegationToken(tokenInfo, hmac);
    }

    public void removeToken(String tokenId) {
        this.tokenCache.removeCache(tokenId);
    }

    public List<DelegationToken> getTokens(Predicate<TokenInformation> filterToken) {
        return this.tokenCache.tokens().stream().filter(filterToken).map(this::getDelegationToken).toList();
    }

    public static boolean filterToken(KafkaPrincipal requesterPrincipal, Optional<List<KafkaPrincipal>> owners, TokenInformation token, Function<String, Boolean> authorizeToken, Function<KafkaPrincipal, Boolean> authorizeRequester) {
        if (owners.isPresent()) {
            if (owners.get().stream().noneMatch(arg_0 -> ((TokenInformation)token).ownerOrRenewer(arg_0))) {
                return false;
            }
        }
        if (token.ownerOrRenewer(requesterPrincipal)) {
            return true;
        }
        return authorizeToken.apply(token.tokenId()) != false || authorizeRequester.apply(token.owner()) != false;
    }
}

