/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.env.internal.AbstractLobCreator;
import org.hibernate.engine.jdbc.env.internal.NonContextualLobCreator;

public class BlobAndClobCreator
extends AbstractLobCreator
implements LobCreator {
    public static final LobCreationContext.Callback<Blob> CREATE_BLOB_CALLBACK = Connection::createBlob;
    public static final LobCreationContext.Callback<Clob> CREATE_CLOB_CALLBACK = Connection::createClob;
    public static final LobCreationContext.Callback<NClob> CREATE_NCLOB_CALLBACK = Connection::createNClob;
    protected final LobCreationContext lobCreationContext;
    protected final boolean useConnectionToCreateLob;

    BlobAndClobCreator(LobCreationContext lobCreationContext, boolean useConnectionToCreateLob) {
        this.lobCreationContext = lobCreationContext;
        this.useConnectionToCreateLob = useConnectionToCreateLob;
    }

    Blob createBlob() {
        return this.lobCreationContext.fromContext(CREATE_BLOB_CALLBACK);
    }

    @Override
    public Blob createBlob(byte[] bytes) {
        Blob blob = this.createBlob();
        try {
            blob.setBytes(1L, bytes);
            return blob;
        }
        catch (SQLException e) {
            throw new JDBCException("Unable to set BLOB bytes after creation", e);
        }
    }

    @Override
    public Blob createBlob(InputStream stream, long length) {
        return NonContextualLobCreator.INSTANCE.createBlob(stream, length);
    }

    Clob createClob() {
        return this.lobCreationContext.fromContext(CREATE_CLOB_CALLBACK);
    }

    NClob createNClob() {
        return this.lobCreationContext.fromContext(CREATE_NCLOB_CALLBACK);
    }

    @Override
    public Clob createClob(String string) {
        try {
            Clob clob = this.createClob();
            clob.setString(1L, string);
            return clob;
        }
        catch (SQLException e) {
            throw new JDBCException("Unable to set CLOB string after creation", e);
        }
    }

    @Override
    public Clob createClob(Reader reader, long length) {
        return NonContextualLobCreator.INSTANCE.createClob(reader, length);
    }

    @Override
    public NClob createNClob(String string) {
        return NonContextualLobCreator.INSTANCE.createNClob(string);
    }

    @Override
    public NClob createNClob(Reader reader, long length) {
        return NonContextualLobCreator.INSTANCE.createNClob(reader, length);
    }

    @Override
    public Blob toJdbcBlob(Blob blob) {
        try {
            if (this.useConnectionToCreateLob) {
                return this.createBlob(blob.getBytes(1L, (int)blob.length()));
            }
            return super.toJdbcBlob(blob);
        }
        catch (SQLException e) {
            throw new JDBCException("Could not create JDBC Blob", e);
        }
    }

    @Override
    public Clob toJdbcClob(Clob clob) {
        try {
            if (this.useConnectionToCreateLob) {
                return this.createClob(clob.getSubString(1L, (int)clob.length()));
            }
            return super.toJdbcClob(clob);
        }
        catch (SQLException e) {
            throw new JDBCException("Could not create JDBC Clob", e);
        }
    }

    @Override
    public NClob toJdbcNClob(NClob clob) {
        try {
            if (this.useConnectionToCreateLob) {
                return this.createNClob(clob.getSubString(1L, (int)clob.length()));
            }
            return super.toJdbcNClob(clob);
        }
        catch (SQLException e) {
            throw new JDBCException("Could not create JDBC NClob", e);
        }
    }
}

