/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.FakeLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.MultiWordChunker;
import org.languagetool.tagging.disambiguation.MultiWordChunker2;
import org.languagetool.tagging.xx.DemoTagger;

public class MultiWordChunkerTest {
    private final JLanguageTool lt = new JLanguageTool((Language)new FakeLanguage(){

        public Tagger createDefaultTagger() {
            return new DemoTagger(){

                public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
                    List tokenReadings = super.tag(sentenceTokens);
                    for (AnalyzedTokenReadings readings : tokenReadings) {
                        if (readings.isWhitespace()) continue;
                        readings.addReading(new AnalyzedToken(readings.getToken(), "FakePosTag", readings.getToken()), "");
                    }
                    return tokenReadings;
                }
            };
        }
    });

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testDisambiguate1() throws IOException {
        MultiWordChunker multiWordChunker = MultiWordChunker.getInstance((String)"/yy/multiwords.txt", (boolean)true, (boolean)true, (boolean)true);
        AnalyzedSentence analyzedSentence = this.lt.getAnalyzedSentence("ah for shame");
        AnalyzedSentence disambiguated = multiWordChunker.disambiguate(analyzedSentence);
        AnalyzedTokenReadings[] tokens = disambiguated.getTokens();
        Assert.assertTrue((boolean)tokens[1].getReadings().toString().contains("<adv>"));
        Assert.assertFalse((boolean)tokens[3].getReadings().toString().contains("adv"));
        Assert.assertTrue((boolean)tokens[5].getReadings().toString().contains("</adv>"));
        Assert.assertTrue((boolean)tokens[1].getReadings().toString().contains("FakePosTag"));
        Assert.assertTrue((boolean)tokens[3].getReadings().toString().contains("FakePosTag"));
        Assert.assertTrue((boolean)tokens[5].getReadings().toString().contains("FakePosTag"));
    }

    @Test
    public void testDisambiguate2() throws IOException {
        MultiWordChunker2 multiWordChunker = new MultiWordChunker2("/yy/multiwords.txt", true);
        AnalyzedSentence analyzedSentence = this.lt.getAnalyzedSentence("Ah for shame");
        AnalyzedSentence disambiguated = multiWordChunker.disambiguate(analyzedSentence);
        AnalyzedTokenReadings[] tokens = disambiguated.getTokens();
        Assert.assertTrue((boolean)tokens[1].getReadings().toString().contains("<adv>"));
        Assert.assertTrue((boolean)tokens[3].getReadings().toString().contains("<adv>"));
        Assert.assertTrue((boolean)tokens[5].getReadings().toString().contains("<adv>"));
        Assert.assertTrue((boolean)tokens[1].getReadings().toString().contains("FakePosTag"));
        Assert.assertTrue((boolean)tokens[3].getReadings().toString().contains("FakePosTag"));
        Assert.assertTrue((boolean)tokens[5].getReadings().toString().contains("FakePosTag"));
    }

    @Test
    public void testDisambiguate2NoMatch() throws IOException {
        MultiWordChunker2 multiWordChunker = new MultiWordChunker2("/yy/multiwords.txt", true);
        AnalyzedSentence analyzedSentence = this.lt.getAnalyzedSentence("ahh for shame");
        AnalyzedSentence disambiguated = multiWordChunker.disambiguate(analyzedSentence);
        AnalyzedTokenReadings[] tokens = disambiguated.getTokens();
        Assert.assertFalse((boolean)tokens[1].getReadings().toString().contains("<adv>"));
    }

    @Test
    public void testDisambiguate2RemoveOtherReadings() throws IOException {
        MultiWordChunker2 multiWordChunker = new MultiWordChunker2("/yy/multiwords.txt", true);
        multiWordChunker.setRemoveOtherReadings(true);
        multiWordChunker.setWrapTag(false);
        AnalyzedSentence analyzedSentence = this.lt.getAnalyzedSentence("ah for shame");
        AnalyzedSentence disambiguated = multiWordChunker.disambiguate(analyzedSentence);
        AnalyzedTokenReadings[] tokens = disambiguated.getTokens();
        Assert.assertTrue((boolean)tokens[1].getReadings().toString().contains("adv"));
        Assert.assertTrue((boolean)tokens[3].getReadings().toString().contains("adv"));
        Assert.assertTrue((boolean)tokens[5].getReadings().toString().contains("adv"));
        Assert.assertFalse((boolean)tokens[1].getReadings().toString().contains("FakePosTag"));
        Assert.assertFalse((boolean)tokens[3].getReadings().toString().contains("FakePosTag"));
        Assert.assertFalse((boolean)tokens[5].getReadings().toString().contains("FakePosTag"));
    }

    @Test
    public void testLettercaseVariants() throws IOException {
        MultiWordChunker multiWordChunker = MultiWordChunker.getInstance((String)"/yy/multiwords.txt", (boolean)true, (boolean)true, (boolean)true);
        HashMap<String, AnalyzedToken> map = new HashMap<String, AnalyzedToken>();
        map.put("rhythm and blues", new AnalyzedToken("rhythm and blues", "NCMS000_", "rhythm and blues"));
        map.put("V\u00eanus de Milo", new AnalyzedToken("V\u00eanus de Milo", "NCFSS00_", "V\u00eanus de Milo"));
        List tokenVariantsRnB = multiWordChunker.getTokenLettercaseVariants("rhythm and blues", map);
        Assert.assertTrue((boolean)tokenVariantsRnB.contains("Rhythm and blues"));
        Assert.assertTrue((boolean)tokenVariantsRnB.contains("Rhythm And Blues"));
        Assert.assertTrue((boolean)tokenVariantsRnB.contains("Rhythm and Blues"));
        Assert.assertTrue((boolean)tokenVariantsRnB.contains("RHYTHM AND BLUES"));
        List tokenVariantsVenus = multiWordChunker.getTokenLettercaseVariants("V\u00eanus de Milo", map);
        Assert.assertFalse((boolean)tokenVariantsVenus.contains("V\u00eanus De Milo"));
        Assert.assertFalse((boolean)tokenVariantsVenus.contains("v\u00eanus de milo"));
        Assert.assertTrue((boolean)tokenVariantsVenus.contains("V\u00caNUS DE MILO"));
    }
}

