/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class GeoHashPrecision
implements TaggedUnion<Kind, Object>,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<GeoHashPrecision> _DESERIALIZER = JsonpDeserializer.lazy(GeoHashPrecision::buildGeoHashPrecisionDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private GeoHashPrecision(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private GeoHashPrecision(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static GeoHashPrecision of(Function<Builder, ObjectBuilder<GeoHashPrecision>> fn) {
        return fn.apply(new Builder()).build();
    }

    public String _toJsonString() {
        switch (this._kind.ordinal()) {
            case 0: {
                return this.distance();
            }
            case 1: {
                return String.valueOf(this.geohashLength());
            }
        }
        throw new IllegalStateException("Unknown kind " + (Object)((Object)this._kind));
    }

    public boolean isDistance() {
        return this._kind == Kind.Distance;
    }

    public String distance() {
        return (String)TaggedUnionUtils.get(this, Kind.Distance);
    }

    public boolean isGeohashLength() {
        return this._kind == Kind.GeohashLength;
    }

    public Integer geohashLength() {
        return (Integer)TaggedUnionUtils.get(this, Kind.GeohashLength);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind.ordinal()) {
                case 0: {
                    generator.write((String)this._value);
                    break;
                }
                case 1: {
                    generator.write(((Integer)this._value).intValue());
                }
            }
        }
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static JsonpDeserializer<GeoHashPrecision> buildGeoHashPrecisionDeserializer() {
        return new UnionDeserializer.Builder<GeoHashPrecision, Kind, Object>(GeoHashPrecision::new, false).addMember(Kind.Distance, JsonpDeserializer.stringDeserializer()).addMember(Kind.GeohashLength, JsonpDeserializer.integerDeserializer()).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode((Object)this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoHashPrecision other = (GeoHashPrecision)o;
        return Objects.equals((Object)this._kind, (Object)other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GeoHashPrecision> {
        private Kind _kind;
        private Object _value;

        public Builder() {
        }

        private Builder(GeoHashPrecision o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<GeoHashPrecision> distance(String v) {
            this._kind = Kind.Distance;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoHashPrecision> geohashLength(Integer v) {
            this._kind = Kind.GeohashLength;
            this._value = v;
            return this;
        }

        @Override
        public GeoHashPrecision build() {
            this._checkSingleUse();
            return new GeoHashPrecision(this);
        }
    }

    public static enum Kind {
        Distance,
        GeohashLength;

    }
}

