/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.rules.ConflictRule;
import org.apache.calcite.rel.rules.HyperEdge;

public class ConflictDetectionHelper {
    private static final ImmutableMap<JoinRelType, Integer> INDEX_OF_TABLE = ImmutableMap.builder().put((Object)JoinRelType.INNER, (Object)0).put((Object)JoinRelType.SEMI, (Object)1).put((Object)JoinRelType.ANTI, (Object)2).put((Object)JoinRelType.LEFT, (Object)3).put((Object)JoinRelType.FULL, (Object)4).build();
    private static final boolean[][] ASSOCIATIVE_TABLE = new boolean[][]{{true, true, true, true, false}, {false, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}};
    private static final boolean[][] LEFT_ASSCOM_TABLE = new boolean[][]{{true, true, true, true, false}, {true, true, true, true, false}, {true, true, true, true, false}, {true, true, true, true, false}, {false, false, false, false, false}};
    private static final boolean[][] RIGHT_ASSCOM_TABLE = new boolean[][]{{true, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}, {false, false, false, false, false}};

    private ConflictDetectionHelper() {
    }

    public static List<ConflictRule> makeConflictRules(List<HyperEdge> leftSubEdges, List<HyperEdge> rightSubEdges, JoinRelType joinType) {
        ArrayList<ConflictRule> conflictRules = new ArrayList<ConflictRule>();
        for (HyperEdge leftSubEdge : leftSubEdges) {
            if (!ConflictDetectionHelper.isAssociative(leftSubEdge.getJoinType(), joinType)) {
                if (leftSubEdge.getLeftNodeUsedInPredicate() != 0L) {
                    conflictRules.add(new ConflictRule(leftSubEdge.getInitialRightNodeBits(), leftSubEdge.getLeftNodeUsedInPredicate()));
                } else {
                    conflictRules.add(new ConflictRule(leftSubEdge.getInitialRightNodeBits(), leftSubEdge.getInitialLeftNodeBits()));
                }
            }
            if (ConflictDetectionHelper.isLeftAsscom(leftSubEdge.getJoinType(), joinType)) continue;
            if (leftSubEdge.getRightNodeUsedInPredicate() != 0L) {
                conflictRules.add(new ConflictRule(leftSubEdge.getInitialLeftNodeBits(), leftSubEdge.getRightNodeUsedInPredicate()));
                continue;
            }
            conflictRules.add(new ConflictRule(leftSubEdge.getInitialLeftNodeBits(), leftSubEdge.getInitialRightNodeBits()));
        }
        for (HyperEdge rightSubEdge : rightSubEdges) {
            if (!ConflictDetectionHelper.isAssociative(joinType, rightSubEdge.getJoinType())) {
                if (rightSubEdge.getRightNodeUsedInPredicate() != 0L) {
                    conflictRules.add(new ConflictRule(rightSubEdge.getInitialLeftNodeBits(), rightSubEdge.getRightNodeUsedInPredicate()));
                } else {
                    conflictRules.add(new ConflictRule(rightSubEdge.getInitialLeftNodeBits(), rightSubEdge.getInitialRightNodeBits()));
                }
            }
            if (ConflictDetectionHelper.isRightAsscom(joinType, rightSubEdge.getJoinType())) continue;
            if (rightSubEdge.getLeftNodeUsedInPredicate() != 0L) {
                conflictRules.add(new ConflictRule(rightSubEdge.getInitialRightNodeBits(), rightSubEdge.getLeftNodeUsedInPredicate()));
                continue;
            }
            conflictRules.add(new ConflictRule(rightSubEdge.getInitialRightNodeBits(), rightSubEdge.getInitialLeftNodeBits()));
        }
        return conflictRules;
    }

    public static boolean isCommutative(JoinRelType operator) {
        return operator == JoinRelType.INNER || operator == JoinRelType.FULL;
    }

    public static boolean isAssociative(JoinRelType operatorA, JoinRelType operatorB) {
        Integer indexA = (Integer)INDEX_OF_TABLE.get((Object)operatorA);
        Integer indexB = (Integer)INDEX_OF_TABLE.get((Object)operatorB);
        if (indexA == null || indexB == null) {
            return false;
        }
        return ASSOCIATIVE_TABLE[indexA][indexB];
    }

    public static boolean isLeftAsscom(JoinRelType operatorA, JoinRelType operatorB) {
        Integer indexA = (Integer)INDEX_OF_TABLE.get((Object)operatorA);
        Integer indexB = (Integer)INDEX_OF_TABLE.get((Object)operatorB);
        if (indexA == null || indexB == null) {
            return false;
        }
        return LEFT_ASSCOM_TABLE[indexA][indexB];
    }

    public static boolean isRightAsscom(JoinRelType operatorA, JoinRelType operatorB) {
        Integer indexA = (Integer)INDEX_OF_TABLE.get((Object)operatorA);
        Integer indexB = (Integer)INDEX_OF_TABLE.get((Object)operatorB);
        if (indexA == null || indexB == null) {
            return false;
        }
        return RIGHT_ASSCOM_TABLE[indexA][indexB];
    }
}

