/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.ngm;

import java.time.Duration;
import java.time.LocalDateTime;
import net.sourceforge.plantuml.project.ngm.NGMAllocation;
import net.sourceforge.plantuml.project.ngm.NGMTaskFixedDuration;
import net.sourceforge.plantuml.project.ngm.NGMTaskFixedTotalEffort;
import net.sourceforge.plantuml.project.ngm.NGMTotalEffort;

public abstract class NGMTask {
    protected final NGMAllocation allocation;

    protected NGMTask(NGMAllocation allocation) {
        this.allocation = allocation;
    }

    public abstract LocalDateTime getStart();

    public abstract void setStart(LocalDateTime var1);

    public abstract LocalDateTime getEnd();

    public abstract void setEnd(LocalDateTime var1);

    public abstract Duration getDuration();

    public abstract NGMTotalEffort getTotalEffort();

    public NGMAllocation getAllocation() {
        return this.allocation;
    }

    public static NGMTask withFixedDuration(NGMAllocation allocation, Duration duration) {
        return new NGMTaskFixedDuration(allocation, duration);
    }

    public static NGMTask withFixedTotalEffort(NGMAllocation allocation, NGMTotalEffort totalEffort) {
        return new NGMTaskFixedTotalEffort(allocation, totalEffort);
    }
}

