# _MapSubNodes\[K: [Any](builtin-Any.md) #share, V: [Any](builtin-Any.md) #share, H: [HashFunction](collections-HashFunction.md)\[K\] val\]
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L-0-98)</span>
```pony
class val _MapSubNodes[K: Any #share, V: Any #share, H: HashFunction[K] val]
```

## Constructors

### create
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L-0-103)</span>


```pony
new iso create(
  size: USize val = 0,
  nm: U32 val = 0,
  dm: U32 val = 0)
: _MapSubNodes[K, V, H] iso^
```
#### Parameters

*   size: [USize](builtin-USize.md) val = 0
*   nm: [U32](builtin-U32.md) val = 0
*   dm: [U32](builtin-U32.md) val = 0

#### Returns

* [_MapSubNodes](collections-persistent-_MapSubNodes.md)\[K, V, H\] iso^

---

## Public fields

### embed nodes: [Array](builtin-Array.md)\[([_MapEntry](collections-persistent-_MapEntry.md)\[K, V, H\] val | [_MapCollisions](collections-persistent-_MapCollisions.md)\[K, V, H\] val | [_MapSubNodes](collections-persistent-_MapSubNodes.md)\[K, V, H\] val)\] iso
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L-0-99)</span>



---

### var node_map: [U32](builtin-U32.md) val
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L-0-100)</span>



---

### var data_map: [U32](builtin-U32.md) val
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L-0-101)</span>



---

## Public Functions

### clone
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L-0-108)</span>


```pony
fun val clone()
: _MapSubNodes[K, V, H] iso^
```

#### Returns

* [_MapSubNodes](collections-persistent-_MapSubNodes.md)\[K, V, H\] iso^

---

### compressed_idx
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L-0-113)</span>


```pony
fun box compressed_idx(
  idx: U32 val)
: U32 val
```
#### Parameters

*   idx: [U32](builtin-U32.md) val

#### Returns

* [U32](builtin-U32.md) val

---

### apply
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L-0-121)</span>


```pony
fun val apply(
  depth: U32 val,
  hash: U32 val,
  k: K)
: (V | None val) ?
```
#### Parameters

*   depth: [U32](builtin-U32.md) val
*   hash: [U32](builtin-U32.md) val
*   k: K

#### Returns

* (V | [None](builtin-None.md) val) ?

---

### update
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L-0-131)</span>


```pony
fun val update(
  depth: U32 val,
  hash: U32 val,
  k: K,
  v: V)
: (_MapSubNodes[K, V, H] val , Bool val) ?
```
#### Parameters

*   depth: [U32](builtin-U32.md) val
*   hash: [U32](builtin-U32.md) val
*   k: K
*   v: V

#### Returns

* ([_MapSubNodes](collections-persistent-_MapSubNodes.md)\[K, V, H\] val , [Bool](builtin-Bool.md) val) ?

---

### update_mut
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L-0-138)</span>


```pony
fun ref update_mut(
  depth: U32 val,
  hash: U32 val,
  k: K,
  v: V)
: Bool val ?
```
#### Parameters

*   depth: [U32](builtin-U32.md) val
*   hash: [U32](builtin-U32.md) val
*   k: K
*   v: V

#### Returns

* [Bool](builtin-Bool.md) val ?

---

### remove
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L-0-197)</span>


```pony
fun val remove(
  depth: U32 val,
  hash: U32 val,
  k: K)
: _MapSubNodes[K, V, H] val ?
```
#### Parameters

*   depth: [U32](builtin-U32.md) val
*   hash: [U32](builtin-U32.md) val
*   k: K

#### Returns

* [_MapSubNodes](collections-persistent-_MapSubNodes.md)\[K, V, H\] val ?

---

### iter
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L-0-240)</span>


```pony
fun val iter()
: _MapIter[K, V, H] ref
```

#### Returns

* [_MapIter](collections-persistent-_MapIter.md)\[K, V, H\] ref

---

