/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.FrameMergeException;
import org.obolibrary.oboformat.model.FrameStructureException;
import org.obolibrary.oboformat.parser.OBOFormatConstants;

public class OBODoc {
    protected Frame headerFrame;
    @Nonnull
    protected final Map<String, Frame> termFrameMap = new HashMap<String, Frame>();
    @Nonnull
    protected final Map<String, Frame> typedefFrameMap = new HashMap<String, Frame>();
    @Nonnull
    protected final Map<String, Frame> instanceFrameMap = new HashMap<String, Frame>();
    @Nonnull
    protected final Collection<Frame> annotationFrames = new LinkedList<Frame>();
    protected Collection<OBODoc> importedOBODocs = new LinkedList<OBODoc>();

    public Frame getHeaderFrame() {
        return this.headerFrame;
    }

    public void setHeaderFrame(Frame headerFrame) {
        this.headerFrame = headerFrame;
    }

    @Nonnull
    public Collection<Frame> getTermFrames() {
        return this.termFrameMap.values();
    }

    @Nonnull
    public Collection<Frame> getTypedefFrames() {
        return this.typedefFrameMap.values();
    }

    @Nonnull
    public Collection<Frame> getInstanceFrames() {
        return this.instanceFrameMap.values();
    }

    public void freezeFrames() {
        this.headerFrame.freeze();
        OBODoc.freezeFrameMap(this.termFrameMap);
        OBODoc.freezeFrameMap(this.typedefFrameMap);
        OBODoc.freezeFrameMap(this.instanceFrameMap);
        for (Frame frame : this.annotationFrames) {
            frame.freeze();
        }
    }

    private static void freezeFrameMap(Map<String, Frame> frameMap) {
        for (Frame frame : frameMap.values()) {
            frame.freeze();
        }
    }

    @Nullable
    public Frame getTermFrame(String id) {
        return this.getTermFrame(id, false);
    }

    @Nullable
    public Frame getTermFrame(String id, boolean followImport) {
        if (!followImport) {
            return this.termFrameMap.get(id);
        }
        HashSet<String> visited = new HashSet<String>();
        visited.add(this.getHeaderDescriptor());
        return this.getTermFrame(id, visited);
    }

    @Nullable
    private Frame getTermFrame(String id, @Nonnull Set<String> visitedDocs) {
        Frame f = this.termFrameMap.get(id);
        if (f != null) {
            return f;
        }
        for (OBODoc doc : this.importedOBODocs) {
            String headerDescriptor = doc.getHeaderDescriptor();
            if (!visitedDocs.contains(headerDescriptor)) {
                visitedDocs.add(headerDescriptor);
                f = doc.getTermFrame(id, true);
            }
            if (f == null) continue;
            return f;
        }
        return null;
    }

    @Nullable
    public Frame getTypedefFrame(String id) {
        return this.getTypedefFrame(id, false);
    }

    @Nullable
    public Frame getTypedefFrame(String id, boolean followImports) {
        if (!followImports) {
            return this.typedefFrameMap.get(id);
        }
        HashSet<String> visited = new HashSet<String>();
        visited.add(this.getHeaderDescriptor());
        return this.getTypedefFrame(id, visited);
    }

    @Nullable
    private Frame getTypedefFrame(String id, @Nonnull Set<String> visitedDocs) {
        Frame f = this.typedefFrameMap.get(id);
        if (f != null) {
            return f;
        }
        for (OBODoc doc : this.importedOBODocs) {
            String headerDescriptor = doc.getHeaderDescriptor();
            if (!visitedDocs.contains(headerDescriptor)) {
                visitedDocs.add(headerDescriptor);
                f = doc.getTypedefFrame(id, true);
            }
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public Frame getInstanceFrame(String id) {
        return this.instanceFrameMap.get(id);
    }

    public Collection<OBODoc> getImportedOBODocs() {
        return this.importedOBODocs;
    }

    public void setImportedOBODocs(Collection<OBODoc> importedOBODocs) {
        this.importedOBODocs = importedOBODocs;
    }

    public void addImportedOBODoc(OBODoc doc) {
        if (this.importedOBODocs == null) {
            this.importedOBODocs = new ArrayList<OBODoc>();
        }
        this.importedOBODocs.add(doc);
    }

    public void addFrame(@Nonnull Frame f) throws FrameMergeException {
        if (f.getType() == Frame.FrameType.TERM) {
            this.addTermFrame(f);
        } else if (f.getType() == Frame.FrameType.TYPEDEF) {
            this.addTypedefFrame(f);
        } else if (f.getType() == Frame.FrameType.INSTANCE) {
            this.addInstanceFrame(f);
        }
    }

    public void addTermFrame(@Nonnull Frame f) throws FrameMergeException {
        String id = f.getId();
        if (this.termFrameMap.containsKey(id)) {
            this.termFrameMap.get(id).merge(f);
        } else {
            this.termFrameMap.put(id, f);
        }
    }

    public void addTypedefFrame(@Nonnull Frame f) throws FrameMergeException {
        String id = f.getId();
        if (this.typedefFrameMap.containsKey(id)) {
            this.typedefFrameMap.get(id).merge(f);
        } else {
            this.typedefFrameMap.put(id, f);
        }
    }

    public void addInstanceFrame(@Nonnull Frame f) throws FrameMergeException {
        String id = f.getId();
        if (this.instanceFrameMap.containsKey(id)) {
            this.instanceFrameMap.get(id).merge(f);
        } else {
            this.instanceFrameMap.put(id, f);
        }
    }

    @Nullable
    public static String getIDSpace(@Nonnull String prefix) {
        if (prefix.equals("RO")) {
            return "http://purl.obolibrary.org/obo/RO_";
        }
        return null;
    }

    public static boolean isTreatXrefsAsEquivalent(@Nullable String prefix) {
        return "RO".equals(prefix);
    }

    public void mergeContents(@Nonnull OBODoc extDoc) throws FrameMergeException {
        for (Frame f : extDoc.getTermFrames()) {
            assert (f != null);
            this.addTermFrame(f);
        }
        for (Frame f : extDoc.getTypedefFrames()) {
            assert (f != null);
            this.addTypedefFrame(f);
        }
        for (Frame f : extDoc.getInstanceFrames()) {
            assert (f != null);
            this.addInstanceFrame(f);
        }
    }

    public void addDefaultOntologyHeader(String defaultOnt) {
        Frame hf = this.getHeaderFrame();
        Clause ontClause = hf.getClause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY);
        if (ontClause == null) {
            ontClause = new Clause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY, defaultOnt);
            hf.addClause(ontClause);
        }
    }

    public void check() throws FrameStructureException {
        this.getHeaderFrame().check();
        for (Frame f : this.getTermFrames()) {
            f.check();
        }
        for (Frame f : this.getTypedefFrames()) {
            f.check();
        }
        for (Frame f : this.getInstanceFrames()) {
            f.check();
        }
    }

    @Nonnull
    public String toString() {
        return this.getHeaderDescriptor();
    }

    @Nonnull
    private String getHeaderDescriptor() {
        return "OBODoc(" + this.headerFrame + ')';
    }
}

