/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.struct;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.struct.FormatAlignment;
import com.oracle.graal.python.builtins.objects.struct.FormatCode;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltins;
import com.oracle.graal.python.lib.CanBeDoubleNode;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CastToJavaBigIntegerNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.NumericSupport;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.PrimitiveValueProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import java.math.BigInteger;

public final class StructNodes {

    @ImportStatic(value={FormatCode.class})
    @GenerateInline(value=false)
    public static abstract class UnpackValueNode
    extends StructBaseNode {
        public abstract Object execute(FormatCode var1, FormatAlignment var2, byte[] var3, int var4);

        @Specialization(guards={"isFmtInteger(formatCode)", "numBytes == formatCode.numBytes()", "numericSupport == getNumericSupport(formatAlignment)"}, limit="getNumBytesLimit()")
        static Object unpack8Cached(FormatCode formatCode, FormatAlignment formatAlignment, byte[] buffer, int offset, @Bind Node inliningTarget, @Cached(value="formatCode.numBytes()") int numBytes, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport, @Cached.Shared @Cached InlinedConditionProfile profilePIntResult, @Cached.Shared @Cached InlinedConditionProfile profileSigned) {
            long num;
            if (profileSigned.profile(inliningTarget, formatCode.isUnsigned())) {
                num = numericSupport.getLongUnsigned(buffer, offset, numBytes);
            } else {
                num = numericSupport.getLong(buffer, offset, numBytes);
                num = UnpackValueNode.handleSign(formatCode, num);
            }
            if (profilePIntResult.profile(inliningTarget, formatCode.isUnsigned() && num < 0L)) {
                return PFactory.createInt(PythonLanguage.get(inliningTarget), UnpackValueNode.getAsUnsignedBigInt(num));
            }
            return num;
        }

        @Specialization(guards={"isFmtInteger(formatCode)"}, replaces={"unpack8Cached"})
        static Object unpack8(FormatCode formatCode, FormatAlignment formatAlignment, byte[] buffer, int offset, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile profilePIntResult, @Cached.Shared @Cached InlinedConditionProfile profileSigned) {
            return UnpackValueNode.unpack8Cached(formatCode, formatAlignment, buffer, offset, inliningTarget, formatCode.numBytes(), UnpackValueNode.getNumericSupport(formatAlignment), profilePIntResult, profileSigned);
        }

        @Specialization(guards={"isFmtFloat(formatCode)", "numericSupport == getNumericSupport(formatAlignment)"}, limit="3")
        static Object unpackFloat8(FormatCode formatCode, FormatAlignment formatAlignment, byte[] buffer, int offset, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport) {
            return numericSupport.getDouble(buffer, offset, formatCode.numBytes());
        }

        @Specialization(guards={"isFmtVoidPtr(formatCode)", "formatAlignment.isNative()"})
        static Object unpackVoidPtr(FormatCode formatCode, FormatAlignment formatAlignment, byte[] buffer, int offset, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile profilePIntResult) {
            long num = UnpackValueNode.getNumericSupport(formatAlignment).getLongUnsigned(buffer, offset, formatCode.numBytes());
            if (profilePIntResult.profile(inliningTarget, num < 0L)) {
                return PFactory.createInt(PythonLanguage.get(inliningTarget), UnpackValueNode.getAsUnsignedBigInt(num));
            }
            return num;
        }

        @Specialization(guards={"isFmtBoolean(formatCode)"})
        static Object unpackBool(FormatCode formatCode, FormatAlignment formatAlignment, byte[] buffer, int offset) {
            return buffer[offset] != 0;
        }

        @Specialization(guards={"isFmtBytes(formatCode)"})
        static Object unpackBytes(FormatCode formatCode, FormatAlignment formatAlignment, byte[] buffer, int offset, @Bind Node inliningTarget, @Cached(value="createIdentityProfile()", inline=false) ValueProfile formatProfile) {
            byte[] bytes;
            switch (((Character)formatProfile.profile((Object)Character.valueOf(formatCode.formatDef.format))).charValue()) {
                case 'c': {
                    bytes = new byte[]{buffer[offset]};
                    break;
                }
                case 's': {
                    bytes = new byte[formatCode.size];
                    PythonUtils.arraycopy(buffer, offset, bytes, 0, formatCode.size);
                    break;
                }
                default: {
                    if (buffer.length == 0) {
                        bytes = buffer;
                        break;
                    }
                    int n = buffer[offset] & 0xFF;
                    if (n >= formatCode.size) {
                        n = formatCode.size - 1;
                    }
                    bytes = new byte[n];
                    PythonUtils.arraycopy(buffer, offset + 1, bytes, 0, n);
                }
            }
            return PFactory.createBytes(PythonLanguage.get(inliningTarget), bytes);
        }

        @Specialization(guards={"!isSupportedFormat(formatCode)"})
        static byte[] unpackUnsupported(FormatCode formatCode, FormatAlignment formatAlignment, byte[] buffer, int offset, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.NotImplementedError, ErrorMessages.STRUCT_FMT_NOT_YET_SUPPORTED, formatCode);
        }
    }

    @ImportStatic(value={FormatCode.class})
    @GenerateInline(value=false)
    public static abstract class PackValueNode
    extends StructBaseNode {
        public abstract void execute(VirtualFrame var1, FormatCode var2, FormatAlignment var3, Object var4, byte[] var5, int var6);

        private static void packLongInternal(Node inliningTarget, FormatCode formatCode, long value, byte[] buffer, int offset, NumericSupport numericSupport, int numBytes, InlinedConditionProfile profileSigned, PRaiseNode raiseNode) {
            long num = profileSigned.profile(inliningTarget, formatCode.isUnsigned()) ? PackValueNode.checkLongUnsigned(inliningTarget, formatCode, value, raiseNode) : PackValueNode.checkLong(inliningTarget, formatCode, value, raiseNode);
            numericSupport.putLong(buffer, offset, num, numBytes);
        }

        @Specialization(guards={"isFmtInteger(formatCode)", "numericSupport == getNumericSupport(formatAlignment)"}, limit="3")
        static void packLong(FormatCode formatCode, FormatAlignment formatAlignment, long value, byte[] buffer, int offset, @Bind Node inliningTarget, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport, @Cached.Shared @Cached InlinedConditionProfile profileSigned, @Cached.Shared @Cached PRaiseNode raiseNode) {
            PackValueNode.packLongInternal(inliningTarget, formatCode, value, buffer, offset, numericSupport, formatCode.numBytes(), profileSigned, raiseNode);
        }

        @Specialization(guards={"isFmtInteger(formatCode)", "numericSupport == getNumericSupport(formatAlignment)"}, limit="3")
        static void packInt(FormatCode formatCode, FormatAlignment formatAlignment, int value, byte[] buffer, int offset, @Bind Node inliningTarget, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport, @Cached.Shared @Cached InlinedConditionProfile profileSigned, @Cached.Shared @Cached PRaiseNode raiseNode) {
            PackValueNode.packLongInternal(inliningTarget, formatCode, value, buffer, offset, numericSupport, formatCode.numBytes(), profileSigned, raiseNode);
        }

        @Specialization(guards={"isFmtInteger(formatCode)", "numericSupport == getNumericSupport(formatAlignment)"}, limit="3")
        static void packPInt(FormatCode formatCode, FormatAlignment formatAlignment, PInt value, byte[] buffer, int offset, @Bind Node inliningTarget, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport, @Cached.Shared @Cached CastToJavaBigIntegerNode toJavaBigIntegerNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                BigInteger num = PackValueNode.checkBigInt(inliningTarget, formatCode, toJavaBigIntegerNode.execute(inliningTarget, value));
                numericSupport.putBigInteger(buffer, offset, num, formatCode.numBytes());
            }
            catch (OverflowException oe) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.ARG_O_O_RANGE);
            }
        }

        @Specialization(guards={"isFmtFloat(formatCode)", "numericSupport == getNumericSupport(formatAlignment)"}, limit="3")
        static void packFloat(FormatCode formatCode, FormatAlignment formatAlignment, double value, byte[] buffer, int offset, @Bind Node inliningTarget, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport, @Cached.Shared @Cached PRaiseNode raiseNode) {
            numericSupport.putDouble(inliningTarget, buffer, offset, value, formatCode.numBytes(), raiseNode);
        }

        @Specialization(guards={"isFmtFloat(formatCode)", "numericSupport == getNumericSupport(formatAlignment)"}, limit="3")
        static void packPFloat(FormatCode formatCode, FormatAlignment formatAlignment, PFloat value, byte[] buffer, int offset, @Bind Node inliningTarget, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport, @Cached.Shared @Cached PRaiseNode raiseNode) {
            PackValueNode.packFloat(formatCode, formatAlignment, value.getValue(), buffer, offset, inliningTarget, numericSupport, raiseNode);
        }

        @Specialization(guards={"isFmtBoolean(formatCode)"})
        static void packBoolean(FormatCode formatCode, FormatAlignment formatAlignment, boolean value, byte[] buffer, int offset) {
            assert (offset < buffer.length);
            buffer[offset] = (byte)(value ? 1 : 0);
        }

        @Specialization(guards={"isFmtBytes(formatCode)"}, limit="getCallSiteInlineCacheMaxDepth()")
        static void packBytes(FormatCode formatCode, FormatAlignment formatAlignment, PBytesLike value, byte[] buffer, int offset, @Bind Node inliningTarget, @Cached.Shared @Cached(value="createEqualityProfile()") PrimitiveValueProfile formatProfile, @CachedLibrary(value="value") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PRaiseNode raiseNode) {
            int n = bufferLib.getBufferLength(value);
            switch (formatProfile.profile(formatCode.formatDef.format)) {
                case 'c': {
                    if (n != 1) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.STRUCT_CHR_FMT_BYTES_1);
                    }
                    assert (n <= buffer.length - offset);
                    bufferLib.readIntoByteArray(value, 0, buffer, offset, n);
                    break;
                }
                case 's': {
                    if (n > formatCode.size) {
                        n = formatCode.size;
                    }
                    assert (n <= buffer.length - offset);
                    if (n <= 0) break;
                    bufferLib.readIntoByteArray(value, 0, buffer, offset, n);
                    break;
                }
                default: {
                    if (n > formatCode.size - 1) {
                        n = formatCode.size - 1;
                    }
                    assert (n + 1 <= buffer.length - offset);
                    if (n > 0) {
                        bufferLib.readIntoByteArray(value, 0, buffer, offset + 1, n);
                    }
                    if (n > 255) {
                        n = 255;
                    }
                    if (buffer.length == 0) {
                        return;
                    }
                    buffer[offset] = (byte)n;
                }
            }
        }

        @Specialization(guards={"numericSupport == getNumericSupport(formatAlignment)"}, limit="1")
        static void packObjectCached(VirtualFrame frame, FormatCode formatCode, FormatAlignment formatAlignment, Object value, byte[] buffer, int offset, @Bind Node inliningTarget, @Cached.Shared @Cached GetLongNode getLongNode, @Cached.Shared @Cached CastToJavaBigIntegerNode toJavaBigIntegerNode, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared @Cached PyObjectIsTrueNode isTrueNode, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport, @Cached.Shared @Cached(value="createEqualityProfile()") PrimitiveValueProfile formatProfile, @Cached.Shared @Cached InlinedConditionProfile profileSigned, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (PackValueNode.isNumberUpToSize8Unsigned(formatCode)) {
                PackValueNode.packLong(formatCode, formatAlignment, getLongNode.execute(frame, value, formatCode.isUnsigned()), buffer, offset, inliningTarget, numericSupport, profileSigned, raiseNode);
            } else if (PackValueNode.isNumberSize8Unsigned(formatCode)) {
                if (value instanceof Integer || value instanceof Long) {
                    PackValueNode.packLong(formatCode, formatAlignment, getLongNode.execute(frame, value, formatCode.isUnsigned()), buffer, offset, inliningTarget, numericSupport, profileSigned, raiseNode);
                } else {
                    try {
                        BigInteger num = PackValueNode.checkBigInt(inliningTarget, formatCode, toJavaBigIntegerNode.execute(inliningTarget, value));
                        PackValueNode.getNumericSupport(formatAlignment).putBigInteger(buffer, offset, num, formatCode.numBytes());
                    }
                    catch (OverflowException oe) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.ARG_O_O_RANGE);
                    }
                    catch (PException pe) {
                        pe.expect(inliningTarget, PythonBuiltinClassType.TypeError, errorProfile);
                        throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.ARG_NOT_T, "an integer");
                    }
                }
            } else if (PackValueNode.isFmtFloat(formatCode)) {
                if (!canBeDoubleNode.execute(inliningTarget, value)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.ARG_NOT_T, "a float");
                }
                PackValueNode.packFloat(formatCode, formatAlignment, asDoubleNode.execute(frame, inliningTarget, value), buffer, offset, inliningTarget, numericSupport, raiseNode);
            } else if (PackValueNode.isFmtVoidPtr(formatCode)) {
                getLongNode.execute(frame, value, formatCode.isUnsigned());
                PackValueNode.packLong(formatCode, formatAlignment, getLongNode.execute(frame, value, formatCode.isUnsigned()), buffer, offset, inliningTarget, numericSupport, profileSigned, raiseNode);
            } else if (PackValueNode.isFmtBoolean(formatCode)) {
                PackValueNode.packBoolean(formatCode, formatAlignment, isTrueNode.execute((Frame)frame, value), buffer, offset);
            } else if (PackValueNode.isFmtBytes(formatCode)) {
                if (!PGuards.isBytes(value)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.ARG_FOR_N_MUST_BE, Character.valueOf(formatCode.formatDef.format), "bytes");
                }
                PackValueNode.packBytes(formatCode, formatAlignment, (PBytesLike)value, buffer, offset, inliningTarget, formatProfile, bufferLib, raiseNode);
            } else {
                throw raiseNode.raise(inliningTarget, PythonErrorType.NotImplementedError, ErrorMessages.STRUCT_FMT_NOT_YET_SUPPORTED, formatCode);
            }
        }

        @Specialization(replaces={"packObjectCached"})
        static void packObject(VirtualFrame frame, FormatCode formatCode, FormatAlignment formatAlignment, Object value, byte[] buffer, int offset, @Bind Node inliningTarget, @Cached.Shared @Cached GetLongNode getLongNode, @Cached.Shared @Cached CastToJavaBigIntegerNode toJavaBigIntegerNode, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared @Cached PyObjectIsTrueNode isTrueNode, @Cached.Shared @Cached(value="createEqualityProfile()") PrimitiveValueProfile formatProfile, @Cached.Shared @Cached InlinedConditionProfile profileSigned, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PRaiseNode raiseNode) {
            PackValueNode.packObjectCached(frame, formatCode, formatAlignment, value, buffer, offset, inliningTarget, getLongNode, toJavaBigIntegerNode, canBeDoubleNode, asDoubleNode, isTrueNode, PackValueNode.getNumericSupport(formatAlignment), formatProfile, profileSigned, errorProfile, bufferLib, raiseNode);
        }
    }

    @ImportStatic(value={PGuards.class})
    public static abstract class StructBaseNode
    extends PNodeWithContext {
        public static final BigInteger UBYTE_MASK = BigInteger.valueOf(255L);
        public static final BigInteger ULONG_MASK = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);

        public static int getNumBytesLimit() {
            return StructBuiltins.ConstructStructNode.NUM_BYTES_LIMIT;
        }

        public static boolean isFormat(FormatCode formatCode, char fmt) {
            return formatCode.formatDef.format == fmt;
        }

        public static boolean isNumberSize8Unsigned(FormatCode formatCode) {
            return formatCode.formatDef.integer && formatCode.numBytes() == 8 && formatCode.isUnsigned();
        }

        public static boolean isNumberUpToSize8Unsigned(FormatCode formatCode) {
            return formatCode.formatDef.integer && (formatCode.numBytes() != 8 || !formatCode.isUnsigned());
        }

        public static boolean isFmtFloat(FormatCode formatCode) {
            return StructBaseNode.isFormat(formatCode, 'e') || StructBaseNode.isFormat(formatCode, 'f') || StructBaseNode.isFormat(formatCode, 'd');
        }

        public static boolean isFmtInteger(FormatCode formatCode) {
            return formatCode.formatDef.integer;
        }

        public static boolean isFmtVoidPtr(FormatCode formatCode) {
            return StructBaseNode.isFormat(formatCode, 'P');
        }

        public static boolean isFmtBoolean(FormatCode formatCode) {
            return StructBaseNode.isFormat(formatCode, '?');
        }

        public static boolean isFmtBytes(FormatCode formatCode) {
            return StructBaseNode.isFormat(formatCode, 'c') || StructBaseNode.isFormat(formatCode, 's') || StructBaseNode.isFormat(formatCode, 'p');
        }

        public static boolean isSupportedFormat(FormatCode formatCode) {
            return StructBaseNode.isFmtBoolean(formatCode) || StructBaseNode.isFmtBytes(formatCode) || StructBaseNode.isFmtFloat(formatCode) || StructBaseNode.isFmtInteger(formatCode) || StructBaseNode.isFmtVoidPtr(formatCode);
        }

        private static PException raiseNumberError(Node inliningTarget, FormatCode formatCode, PRaiseNode raiseNode) {
            if (formatCode.formatDef.name == null) {
                return raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.ARG_O_O_RANGE);
            }
            return raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.FMT_REQ_RANGE, formatCode.formatDef.name, formatCode.formatDef.min, formatCode.formatDef.max);
        }

        private static PException raiseNumberErrorUncached(Node raisingNode, FormatCode formatCode) {
            if (formatCode.formatDef.name == null) {
                return PRaiseNode.raiseStatic(raisingNode, PythonErrorType.StructError, ErrorMessages.ARG_O_O_RANGE);
            }
            return PRaiseNode.raiseStatic(raisingNode, PythonErrorType.StructError, ErrorMessages.FMT_REQ_RANGE, formatCode.formatDef.name, formatCode.formatDef.min, formatCode.formatDef.max);
        }

        public static long checkLong(Node inliningTarget, FormatCode formatCode, long value, PRaiseNode raiseNode) {
            if (value < formatCode.formatDef.min || value > formatCode.formatDef.max) {
                throw StructBaseNode.raiseNumberError(inliningTarget, formatCode, raiseNode);
            }
            return value;
        }

        public static long checkLongUnsigned(Node inliningTarget, FormatCode formatCode, long value, PRaiseNode raiseNode) {
            if (value < formatCode.formatDef.min || Long.compareUnsigned(value, formatCode.formatDef.max) > 0) {
                throw StructBaseNode.raiseNumberError(inliningTarget, formatCode, raiseNode);
            }
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        public static BigInteger checkBigInt(Node raisingNode, FormatCode formatCode, BigInteger value) {
            if (value.compareTo(BigInteger.valueOf(formatCode.formatDef.min)) < 0 || value.compareTo(BigInteger.valueOf(formatCode.formatDef.max).and(ULONG_MASK)) > 0) {
                throw StructBaseNode.raiseNumberErrorUncached(raisingNode, formatCode);
            }
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        public static BigInteger getAsUnsignedBigInt(long value) {
            return BigInteger.valueOf(value).and(ULONG_MASK);
        }

        public static long handleSign(FormatCode code, long num) {
            long value = num;
            if ((value >>> code.numBytes() * 8 - 1 & 1L) == 1L) {
                value |= -(value & 1L << 8 * code.numBytes() - 1);
            }
            return value;
        }

        public static NumericSupport getNumericSupport(FormatAlignment formatAlignment) {
            return formatAlignment.bigEndian ? NumericSupport.bigEndian() : NumericSupport.littleEndian();
        }
    }

    @GenerateInline(value=false)
    public static abstract class GetLongNode
    extends PNodeWithContext {
        public abstract long execute(VirtualFrame var1, Object var2, boolean var3);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Specialization
        static long get(VirtualFrame frame, Object value, boolean unsigned, @Bind Node inliningTarget, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached PyIndexCheckNode indexCheckNode, @Cached PyLongCheckNode pyLongCheckNode, @Cached PyNumberIndexNode indexNode, @Cached PyLongAsLongNode pyLongAsLongNode, @Cached PRaiseNode raiseNode) {
            long x;
            Object longValue;
            if (!pyLongCheckNode.execute(inliningTarget, value)) {
                if (!indexCheckNode.execute(inliningTarget, value)) throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.ARG_NOT_T, "an integer");
                longValue = indexNode.execute((Frame)frame, inliningTarget, value);
            } else {
                longValue = value;
            }
            try {
                x = pyLongAsLongNode.execute((Frame)frame, inliningTarget, longValue);
            }
            catch (PException pe) {
                pe.expect(inliningTarget, PythonBuiltinClassType.OverflowError, errorProfile);
                throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.ARG_O_O_RANGE);
            }
            if (!unsigned || x >= 0L) return x;
            throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.ARG_O_O_RANGE);
        }
    }
}

