/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import org.firebirdsql.gds.DefaultMessageTemplate;
import org.firebirdsql.gds.MessageTemplate;
import org.firebirdsql.jaybird.util.StringUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class MessageLoader {
    private final MessageDefinition messageDefinition;
    private final Properties messages;
    private final Properties sqlStates;

    private MessageLoader(MessageDefinition messageDefinition) {
        this.messageDefinition = messageDefinition;
        this.messages = messageDefinition.loadMessages();
        this.sqlStates = messageDefinition.loadSqlStates();
    }

    static Stream<MessageTemplate> loadMessageTemplates(int facility) {
        try {
            return new MessageLoader(MessageDefinition.of(facility)).createMessageTemplates();
        }
        catch (IllegalArgumentException e) {
            System.getLogger(MessageLoader.class.getName()).log(System.Logger.Level.DEBUG, "Failed to load message templates for facility: " + facility, (Throwable)e);
            return Stream.empty();
        }
    }

    Stream<MessageTemplate> createMessageTemplates() {
        return this.messages.stringPropertyNames().stream().map(this::createMessageTemplate).filter(Objects::nonNull);
    }

    @Nullable MessageTemplate createMessageTemplate(String errorCodeString) {
        try {
            int errorCode = Integer.parseInt(errorCodeString);
            String templateText = StringUtils.trimToNull(this.messages.getProperty(errorCodeString));
            if (templateText == null) {
                System.getLogger(MessageLoader.class.getName()).log(System.Logger.Level.DEBUG, "No template text for error code {0} in resource {1}", errorCodeString, this.messageDefinition);
                return null;
            }
            String sqlState = StringUtils.trimToNull(this.sqlStates.getProperty(errorCodeString));
            if (sqlState != null) {
                sqlState = sqlState.intern();
            }
            try {
                return new DefaultMessageTemplate(errorCode, templateText, sqlState);
            }
            catch (IllegalArgumentException e) {
                System.getLogger(MessageLoader.class.getName()).log(System.Logger.Level.DEBUG, "Error code {0} has invalid SQL state value ''{1}'' in resource {2}", errorCodeString, sqlState, this.messageDefinition);
                return new DefaultMessageTemplate(errorCode, templateText);
            }
        }
        catch (NumberFormatException e) {
            System.getLogger(MessageLoader.class.getName()).log(System.Logger.Level.DEBUG, "Non-integer error code value ''{0}'' in resource {1}", errorCodeString, this.messageDefinition);
            return null;
        }
    }

    private record MessageDefinition(String messageResourceName, String sqlStateResourceName) {
        private static final String FIREBIRD_MESSAGE_FORMAT = "org/firebirdsql/firebird_%d_error_msg";
        private static final String FIREBIRD_SQL_STATES_FORMAT = "org/firebirdsql/firebird_%d_sql_states";
        private static final String JAYBIRD_MESSAGES = "org/firebirdsql/jaybird_error_msg";
        private static final String JAYBIRD_SQLSTATES = "org/firebirdsql/jaybird_error_sqlstates";

        private Properties loadMessages() {
            return MessageDefinition.loadProperties(this.messageResourceName);
        }

        private Properties loadSqlStates() {
            return MessageDefinition.loadProperties(this.sqlStateResourceName);
        }

        private static Properties loadProperties(String resource) {
            Properties properties = new Properties();
            try (InputStream in = MessageDefinition.getResourceAsStream("/" + resource + ".properties");){
                if (in != null) {
                    properties.load(in);
                } else {
                    System.getLogger(MessageLoader.class.getName()).log(System.Logger.Level.WARNING, "Unable to load resource; resource {0} is not found", resource);
                }
            }
            catch (IOException e) {
                System.getLogger(MessageLoader.class.getName()).log(System.Logger.Level.ERROR, "Unable to load resource " + resource, (Throwable)e);
            }
            return properties;
        }

        private static @Nullable InputStream getResourceAsStream(String res) {
            InputStream in = MessageLoader.class.getResourceAsStream(res);
            if (in == null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                in = cl.getResourceAsStream(res);
            }
            return in;
        }

        private static MessageDefinition of(int facility) {
            if (facility < 0 || facility >= 27) {
                throw new IllegalArgumentException("Unsupported facility: " + facility);
            }
            if (facility == 26) {
                return new MessageDefinition(JAYBIRD_MESSAGES, JAYBIRD_SQLSTATES);
            }
            return new MessageDefinition(FIREBIRD_MESSAGE_FORMAT.formatted(facility), FIREBIRD_SQL_STATES_FORMAT.formatted(facility));
        }
    }
}

