/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.opentelemetry;

import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosableTracerShim
implements Tracer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Tracer shim;
    private final SdkTracerProvider sdkTracerProvider;

    public ClosableTracerShim(Tracer shim, SdkTracerProvider sdkTracerProvider) {
        this.shim = shim;
        this.sdkTracerProvider = sdkTracerProvider;
    }

    public ScopeManager scopeManager() {
        return this.shim.scopeManager();
    }

    public Span activeSpan() {
        return this.shim.activeSpan();
    }

    public Scope activateSpan(Span span) {
        return this.shim.activateSpan(span);
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return this.shim.buildSpan(operationName);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        this.shim.inject(spanContext, format, carrier);
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        return this.shim.extract(format, carrier);
    }

    public void close() {
        this.shim.close();
        log.debug("Closing wrapped OTEL tracer instance.");
        this.sdkTracerProvider.forceFlush();
        this.sdkTracerProvider.close();
    }
}

