/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av.impl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.os.DynamicLibraryBundle;
import com.jogamp.common.os.DynamicLibraryBundleInfo;
import com.jogamp.common.util.RunnableExecutor;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.opengl.GLProfile;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import jogamp.opengl.util.av.impl.FFMPEGMediaPlayer;
import jogamp.opengl.util.av.impl.FFMPEGNatives;
import jogamp.opengl.util.av.impl.FFMPEGStaticNatives;
import jogamp.opengl.util.av.impl.FFMPEGv0400Natives;
import jogamp.opengl.util.av.impl.FFMPEGv0500Natives;
import jogamp.opengl.util.av.impl.FFMPEGv0600Natives;

class FFMPEGDynamicLibraryBundleInfo
implements DynamicLibraryBundleInfo {
    private static final boolean DEBUG = FFMPEGMediaPlayer.DEBUG || DynamicLibraryBundleInfo.DEBUG;
    private static final List<String> glueLibNames = new ArrayList<String>();
    private static final int symbolCount = 59;
    private static final String[] symbolNames = new String[]{"avutil_version", "avformat_version", "avcodec_version", "avdevice_version", "swresample_version", "avcodec_close", "avcodec_string", "avcodec_find_decoder", "avcodec_alloc_context3", "avcodec_free_context", "avcodec_parameters_to_context", "avcodec_open2", "av_frame_alloc", "av_frame_free", "avcodec_default_get_buffer2", "av_image_fill_linesizes", "avcodec_flush_buffers", "av_packet_alloc", "av_packet_free", "av_new_packet", "av_packet_unref", "avcodec_send_packet", "avcodec_receive_frame", "av_pix_fmt_desc_get", "av_frame_unref", "av_realloc", "av_free", "av_get_bits_per_pixel", "av_samples_get_buffer_size", "av_get_bytes_per_sample", "av_opt_set_int", "av_dict_get", "av_dict_count", "av_dict_set", "av_dict_free", "av_channel_layout_default", "av_channel_layout_uninit", "av_channel_layout_describe", "av_opt_set_chlayout", "avformat_alloc_context", "avformat_free_context", "avformat_close_input", "av_find_input_format", "avformat_open_input", "av_dump_format", "av_read_frame", "av_seek_frame", "avformat_seek_file", "av_read_play", "av_read_pause", "avformat_network_init", "avformat_network_deinit", "avformat_find_stream_info", "avdevice_register_all", "av_opt_set_sample_fmt", "swr_alloc", "swr_init", "swr_free", "swr_convert"};
    private static final String[] optionalSymbolNames = new String[]{"avformat_seek_file", "av_dict_count", "av_channel_layout_default", "av_channel_layout_uninit", "av_channel_layout_describe", "av_opt_set_chlayout", "avdevice_version", "avdevice_register_all", "av_opt_set_sample_fmt", "swr_alloc", "swr_init", "swr_free", "swr_convert"};
    private static final int LIB_COUNT = 5;
    private static final int LIB_IDX_UTI = 0;
    private static final int LIB_IDX_FMT = 1;
    private static final int LIB_IDX_COD = 2;
    private static final int LIB_IDX_DEV = 3;
    private static final int LIB_IDX_SWR = 4;
    private static final boolean[] libLoaded = new boolean[5];
    private static final long[] symbolAddr = new long[59];
    private static final boolean ready;
    private static final boolean libsCFUSLoaded;
    static final VersionNumber avCodecVersion;
    static final VersionNumber avFormatVersion;
    static final VersionNumber avUtilVersion;
    static final VersionNumber avDeviceVersion;
    static final VersionNumber swResampleVersion;
    private static final FFMPEGNatives natives;
    private static final PrivilegedAction<DynamicLibraryBundle> privInitSymbolsAction;

    private static final boolean initSymbols(VersionNumber[] versionNumberArray) {
        for (int i = 0; i < libLoaded.length; ++i) {
            FFMPEGDynamicLibraryBundleInfo.libLoaded[i] = false;
        }
        if (symbolNames.length != 59) {
            throw new InternalError("XXX0 " + symbolNames.length + " != " + 59);
        }
        DynamicLibraryBundle dynamicLibraryBundle = (DynamicLibraryBundle)SecurityUtil.doPrivileged(privInitSymbolsAction);
        if (null == dynamicLibraryBundle) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(optionalSymbolNames));
        boolean bl = true;
        for (int i = 0; i < 59; ++i) {
            if (0L != symbolAddr[i]) continue;
            String string = symbolNames[i];
            if (!hashSet.contains(string)) {
                System.err.println("FFmpeg: Fail: Could not resolve symbol <" + symbolNames[i] + ">: not optional, no alternatives.");
                bl = false;
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("FFmpeg: OK: Unresolved optional symbol <" + symbolNames[i] + ">");
        }
        versionNumberArray[0] = FFMPEGStaticNatives.getAVVersion(FFMPEGStaticNatives.getAvVersion0(symbolAddr[0]));
        versionNumberArray[1] = FFMPEGStaticNatives.getAVVersion(FFMPEGStaticNatives.getAvVersion0(symbolAddr[1]));
        versionNumberArray[2] = FFMPEGStaticNatives.getAVVersion(FFMPEGStaticNatives.getAvVersion0(symbolAddr[2]));
        versionNumberArray[3] = 0L != symbolAddr[3] ? FFMPEGStaticNatives.getAVVersion(FFMPEGStaticNatives.getAvVersion0(symbolAddr[3])) : new VersionNumber(0, 0, 0);
        versionNumberArray[4] = FFMPEGStaticNatives.getAVVersion(FFMPEGStaticNatives.getAvVersion0(symbolAddr[4]));
        return bl;
    }

    static boolean libsLoaded() {
        return libsCFUSLoaded;
    }

    static boolean avDeviceLoaded() {
        return libLoaded[3];
    }

    static boolean swResampleLoaded() {
        return libLoaded[4];
    }

    static FFMPEGNatives getNatives() {
        return natives;
    }

    static boolean initSingleton() {
        return ready;
    }

    protected FFMPEGDynamicLibraryBundleInfo() {
    }

    public final boolean shallLinkGlobal() {
        return true;
    }

    public final boolean shallLookupGlobal() {
        return true;
    }

    public final List<String> getGlueLibNames() {
        return glueLibNames;
    }

    public final boolean searchToolLibInSystemPath() {
        return true;
    }

    public final boolean searchToolLibSystemPathFirst() {
        return true;
    }

    public final List<List<String>> getToolLibNames() {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (FFMPEGMediaPlayer.PREFER_SYSTEM_LIBS) {
            arrayList2.add("avutil");
        } else {
            arrayList2.add("internal_avutil");
        }
        arrayList2.add("libavutil.so.58");
        arrayList2.add("libavutil.so.57");
        arrayList2.add("libavutil.so.56");
        arrayList2.add("avutil-58");
        arrayList2.add("avutil-57");
        arrayList2.add("avutil-56");
        if (FFMPEGMediaPlayer.PREFER_SYSTEM_LIBS) {
            arrayList2.add("internal_avutil");
        } else {
            arrayList2.add("avutil");
        }
        arrayList.add(arrayList2);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (FFMPEGMediaPlayer.PREFER_SYSTEM_LIBS) {
            arrayList3.add("avformat");
        } else {
            arrayList3.add("internal_avformat");
        }
        arrayList3.add("libavformat.so.60");
        arrayList3.add("libavformat.so.59");
        arrayList3.add("libavformat.so.58");
        arrayList3.add("avformat-60");
        arrayList3.add("avformat-59");
        arrayList3.add("avformat-58");
        if (FFMPEGMediaPlayer.PREFER_SYSTEM_LIBS) {
            arrayList3.add("internal_avformat");
        } else {
            arrayList3.add("avformat");
        }
        arrayList.add(arrayList3);
        ArrayList<String> arrayList4 = new ArrayList<String>();
        if (FFMPEGMediaPlayer.PREFER_SYSTEM_LIBS) {
            arrayList4.add("avcodec");
        } else {
            arrayList4.add("internal_avcodec");
        }
        arrayList4.add("libavcodec.so.60");
        arrayList4.add("libavcodec.so.59");
        arrayList4.add("libavcodec.so.58");
        arrayList4.add("avcodec-60");
        arrayList4.add("avcodec-59");
        arrayList4.add("avcodec-58");
        if (FFMPEGMediaPlayer.PREFER_SYSTEM_LIBS) {
            arrayList4.add("internal_avcodec");
        } else {
            arrayList4.add("avcodec");
        }
        arrayList.add(arrayList4);
        ArrayList<String> arrayList5 = new ArrayList<String>();
        if (FFMPEGMediaPlayer.PREFER_SYSTEM_LIBS) {
            arrayList5.add("avdevice");
        } else {
            arrayList5.add("internal_avdevice");
        }
        arrayList5.add("libavdevice.so.60");
        arrayList5.add("libavdevice.so.59");
        arrayList5.add("libavdevice.so.58");
        arrayList5.add("avdevice-60");
        arrayList5.add("avdevice-59");
        arrayList5.add("avdevice-58");
        if (FFMPEGMediaPlayer.PREFER_SYSTEM_LIBS) {
            arrayList5.add("internal_avdevice");
        } else {
            arrayList5.add("avdevice");
        }
        arrayList.add(arrayList5);
        ArrayList<String> arrayList6 = new ArrayList<String>();
        if (FFMPEGMediaPlayer.PREFER_SYSTEM_LIBS) {
            arrayList6.add("swresample");
        } else {
            arrayList6.add("internal_swresample");
        }
        arrayList6.add("libswresample.so.4");
        arrayList6.add("libswresample.so.3");
        arrayList6.add("swresample-4");
        arrayList6.add("swresample-3");
        if (FFMPEGMediaPlayer.PREFER_SYSTEM_LIBS) {
            arrayList6.add("internal_swresample");
        } else {
            arrayList6.add("swresample");
        }
        arrayList.add(arrayList6);
        return arrayList;
    }

    public final List<String> getToolGetProcAddressFuncNameList() {
        return null;
    }

    public final long toolGetProcAddress(long l, String string) {
        return 0L;
    }

    public final boolean useToolGetProcAdressFirst(String string) {
        return false;
    }

    public final RunnableExecutor getLibLoaderExecutor() {
        return DynamicLibraryBundle.getDefaultRunnableExecutor();
    }

    static {
        privInitSymbolsAction = new PrivilegedAction<DynamicLibraryBundle>(){

            @Override
            public DynamicLibraryBundle run() {
                int n;
                DynamicLibraryBundle dynamicLibraryBundle = new DynamicLibraryBundle((DynamicLibraryBundleInfo)new FFMPEGDynamicLibraryBundleInfo());
                for (n = 0; n < libLoaded.length; ++n) {
                    libLoaded[n] = dynamicLibraryBundle.isToolLibLoaded(n);
                }
                if (!(libLoaded[2] && libLoaded[1] && libLoaded[0] && libLoaded[4])) {
                    System.err.println("FFMPEG Tool library incomplete: [ avcodec " + libLoaded[2] + ", avformat " + libLoaded[1] + ", avutil " + libLoaded[0] + ", swres " + libLoaded[4] + " ]");
                    return null;
                }
                dynamicLibraryBundle.claimAllLinkPermission();
                try {
                    for (n = 0; n < 59; ++n) {
                        symbolAddr[n] = dynamicLibraryBundle.dynamicLookupFunction(symbolNames[n]);
                    }
                }
                finally {
                    dynamicLibraryBundle.releaseAllLinkPermission();
                }
                return dynamicLibraryBundle;
            }
        };
        GLProfile.initSingleton();
        boolean bl = false;
        VersionNumber[] versionNumberArray = new VersionNumber[5];
        try {
            bl = FFMPEGDynamicLibraryBundleInfo.initSymbols(versionNumberArray);
        }
        catch (Throwable throwable) {
            ExceptionUtils.dumpThrowable((String)"", (Throwable)throwable);
        }
        libsCFUSLoaded = libLoaded[2] && libLoaded[1] && libLoaded[0] && libLoaded[4];
        avUtilVersion = versionNumberArray[0];
        avFormatVersion = versionNumberArray[1];
        avCodecVersion = versionNumberArray[2];
        avDeviceVersion = versionNumberArray[3];
        swResampleVersion = versionNumberArray[4];
        if (!libsCFUSLoaded) {
            String string = "";
            if (!libLoaded[2]) {
                string = string + "avcodec, ";
            }
            if (!libLoaded[1]) {
                string = string + "avformat, ";
            }
            if (!libLoaded[0]) {
                string = string + "avutil, ";
            }
            if (!libLoaded[4]) {
                string = string + "swresample";
            }
            System.err.println("FFmpeg Not Available, missing libs: " + string);
            natives = null;
            ready = false;
        } else if (!bl) {
            System.err.println("FFmpeg Symbol Lookup Failed");
            natives = null;
            ready = false;
        } else {
            int n = avCodecVersion.getMajor();
            int n2 = avFormatVersion.getMajor();
            int n3 = avUtilVersion.getMajor();
            int n4 = avDeviceVersion.getMajor();
            int n5 = swResampleVersion.getMajor();
            natives = n == 58 && n2 == 58 && (n4 == 58 || n4 == 0) && n3 == 56 && n5 == 3 ? new FFMPEGv0400Natives() : (n == 59 && n2 == 59 && (n4 == 59 || n4 == 0) && n3 == 57 && n5 == 4 ? new FFMPEGv0500Natives() : (n == 60 && n2 == 60 && (n4 == 60 || n4 == 0) && n3 == 58 && n5 == 4 ? new FFMPEGv0600Natives() : null));
            if (null == natives) {
                System.err.println("FFmpeg Native Class matching runtime-versions not found.");
                ready = false;
            } else if (FFMPEGStaticNatives.initIDs0()) {
                ready = natives.initSymbols0(symbolAddr, 59);
                if (!ready) {
                    System.err.println("FFmpeg Native Symbols Initialization Failed");
                }
            } else {
                System.err.println("FFmpeg Native ID Initialization Failed");
                ready = false;
            }
        }
    }
}

