/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.util.Deque;
import java.util.jar.JarFile;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.tomcat.util.compat.Jre16Compat;
import org.apache.tomcat.util.compat.Jre19Compat;
import org.apache.tomcat.util.compat.Jre21Compat;
import org.apache.tomcat.util.compat.Jre8Compat;
import org.apache.tomcat.util.compat.Jre9Compat;
import org.apache.tomcat.util.res.StringManager;

public class JreCompat {
    private static final int RUNTIME_MAJOR_VERSION = 7;
    private static final JreCompat instance;
    private static final boolean jre8Available;
    private static final boolean jre9Available;
    private static final boolean jre11Available;
    private static final boolean jre16Available;
    private static final boolean jre19Available;
    private static final boolean jre21Available;
    private static final StringManager sm;

    public static JreCompat getInstance() {
        return instance;
    }

    public static boolean isAlpnSupported() {
        return JreCompat.isJre9Available() || JreCompat.isJre8Available() && Jre8Compat.isAlpnSupported();
    }

    public static boolean isJre8Available() {
        return jre8Available;
    }

    public static boolean isJre9Available() {
        return jre9Available;
    }

    public static boolean isJre11Available() {
        return jre11Available;
    }

    public static boolean isJre16Available() {
        return jre16Available;
    }

    public static boolean isJre19Available() {
        return jre19Available;
    }

    public static boolean isJre21Available() {
        return jre21Available;
    }

    public void setUseServerCipherSuitesOrder(SSLParameters sSLParameters, boolean bl) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noServerCipherSuiteOrder"));
    }

    public KeyStore.LoadStoreParameter getDomainLoadStoreParameter(URI uRI) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noDomainLoadStoreParameter"));
    }

    public boolean isInstanceOfInaccessibleObjectException(Throwable throwable) {
        return false;
    }

    public void setApplicationProtocols(SSLParameters sSLParameters, String[] stringArray) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noApplicationProtocols"));
    }

    public String getApplicationProtocol(SSLEngine sSLEngine) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noApplicationProtocol"));
    }

    public void disableCachingForJarUrlConnections() throws IOException {
        URL uRL = new URL("jar:file://dummy.jar!/");
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDefaultUseCaches(false);
    }

    public void addBootModulePath(Deque<URL> deque) {
    }

    public final JarFile jarFileNewInstance(String string) throws IOException {
        return this.jarFileNewInstance(new File(string));
    }

    public JarFile jarFileNewInstance(File file) throws IOException {
        return new JarFile(file);
    }

    public boolean jarFileIsMultiRelease(JarFile jarFile) {
        return false;
    }

    public int jarFileRuntimeMajorVersion() {
        return 7;
    }

    public boolean canAccess(Object object, AccessibleObject accessibleObject) {
        return true;
    }

    public boolean isExported(Class<?> clazz) {
        return true;
    }

    public String getModuleName(Class<?> clazz) {
        return "NO_MODULE_JAVA_8";
    }

    public Object getExecutor(Thread thread) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Object object = null;
        Object object2 = null;
        for (String string : new String[]{"target", "runnable", "action"}) {
            try {
                Field field = thread.getClass().getDeclaredField(string);
                field.setAccessible(true);
                object2 = field.get(thread);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        if (object2 != null && object2.getClass().getCanonicalName() != null && (object2.getClass().getCanonicalName().equals("org.apache.tomcat.util.threads.ThreadPoolExecutor.Worker") || object2.getClass().getCanonicalName().equals("java.util.concurrent.ThreadPoolExecutor.Worker"))) {
            Field field = object2.getClass().getDeclaredField("this$0");
            field.setAccessible(true);
            object = field.get(object2);
        }
        return object;
    }

    public Object createVirtualThreadBuilder(String string) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noVirtualThreads"));
    }

    public void threadBuilderStart(Object object, Runnable runnable) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noVirtualThreads"));
    }

    static {
        sm = StringManager.getManager(JreCompat.class);
        if (Jre21Compat.isSupported()) {
            instance = new Jre21Compat();
            jre21Available = true;
            jre19Available = true;
            jre16Available = true;
            jre9Available = true;
            jre8Available = true;
        } else if (Jre19Compat.isSupported()) {
            instance = new Jre19Compat();
            jre21Available = false;
            jre19Available = true;
            jre16Available = true;
            jre9Available = true;
            jre8Available = true;
        } else if (Jre16Compat.isSupported()) {
            instance = new Jre16Compat();
            jre21Available = false;
            jre19Available = false;
            jre16Available = true;
            jre9Available = true;
            jre8Available = true;
        } else if (Jre9Compat.isSupported()) {
            instance = new Jre9Compat();
            jre21Available = false;
            jre19Available = false;
            jre16Available = false;
            jre9Available = true;
            jre8Available = true;
        } else if (Jre8Compat.isSupported()) {
            instance = new Jre8Compat();
            jre21Available = false;
            jre19Available = false;
            jre16Available = false;
            jre9Available = false;
            jre8Available = true;
        } else {
            instance = new JreCompat();
            jre21Available = false;
            jre19Available = false;
            jre16Available = false;
            jre9Available = false;
            jre8Available = false;
        }
        jre11Available = instance.jarFileRuntimeMajorVersion() >= 11;
    }
}

