/*
 * Decompiled with CFR 0.152.
 */
package vtk.sample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import vtk.vtkActor;
import vtk.vtkConeSource;
import vtk.vtkNativeLibrary;
import vtk.vtkObject;
import vtk.vtkPanel;
import vtk.vtkPolyDataMapper;

public class ReleaseVtkPanel {
    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                vtkObject.JAVA_OBJECT_MANAGER.getAutoGarbageCollector().SetScheduleTime(5L, TimeUnit.SECONDS);
                vtkObject.JAVA_OBJECT_MANAGER.getAutoGarbageCollector().SetDebug(true);
                vtkObject.JAVA_OBJECT_MANAGER.getAutoGarbageCollector().Start();
                JButton jButton = new JButton("Start VTK application");
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        final VtkApplication vtkApplication = new VtkApplication();
                        JFrame jFrame = ReleaseVtkPanel.buildFrame("VtkApp", vtkApplication, 400, 200);
                        jFrame.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent windowEvent) {
                                vtkApplication.Delete();
                            }
                        });
                        jFrame.setVisible(true);
                    }
                });
                JFrame jFrame = ReleaseVtkPanel.buildFrame("Launcher", jButton, 200, 200);
                jFrame.setDefaultCloseOperation(3);
                jFrame.setVisible(true);
            }
        });
    }

    public static JFrame buildFrame(String string, JComponent jComponent, int n, int n2) {
        JFrame jFrame = new JFrame(string);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jComponent, "Center");
        jFrame.setDefaultCloseOperation(2);
        jFrame.setSize(n, n2);
        jFrame.setLocationRelativeTo(null);
        return jFrame;
    }

    static {
        if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
            for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibrary.values()) {
                if (vtkNativeLibrary2.IsLoaded()) continue;
                System.out.println(vtkNativeLibrary2.GetLibraryName() + " not loaded");
            }
        }
        vtkNativeLibrary.DisableOutputWindow(null);
    }

    private static class VtkApplication
    extends JPanel {
        private static final long serialVersionUID = -6486953735097088917L;
        private vtkPanel panel3dA = new vtkPanel();
        private vtkPanel panel3dB = new vtkPanel();

        public VtkApplication() {
            super(new GridLayout(1, 2));
            vtkConeSource vtkConeSource2 = new vtkConeSource();
            vtkPolyDataMapper vtkPolyDataMapper2 = new vtkPolyDataMapper();
            vtkActor vtkActor2 = new vtkActor();
            vtkPolyDataMapper2.SetInputConnection(vtkConeSource2.GetOutputPort());
            vtkActor2.SetMapper(vtkPolyDataMapper2);
            this.panel3dA.GetRenderer().AddActor(vtkActor2);
            this.add(this.panel3dA);
            this.panel3dB.GetRenderer().AddActor(vtkActor2);
            this.add(this.panel3dB);
        }

        public void Delete() {
            this.panel3dA.Delete();
            this.panel3dB.Delete();
        }
    }
}

