/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.g2d;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorGradient;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverRectangleG2d;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverShadowedG2d;
import net.sourceforge.plantuml.klimt.geom.EnsureVisible;
import net.sourceforge.plantuml.klimt.shape.UEllipse;

public class DriverEllipseG2d
extends DriverShadowedG2d
implements UDriver<UEllipse, Graphics2D> {
    private final double dpiFactor;
    private final EnsureVisible visible;
    private static final double ROU = 5.0;

    public DriverEllipseG2d(double dpiFactor, EnsureVisible visible) {
        this.dpiFactor = dpiFactor;
        this.visible = visible;
    }

    @Override
    public void draw(UEllipse ellipse, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        g2d.setStroke(new BasicStroke((float)param.getStroke().getThickness()));
        this.visible.ensureVisible(x, y);
        this.visible.ensureVisible(x + ellipse.getWidth(), y + ellipse.getHeight());
        HColor color = param.getColor();
        if (ellipse.getStart() == 0.0 && ellipse.getExtend() == 0.0) {
            HColor back;
            Ellipse2D.Double shape = new Ellipse2D.Double(x, y, ellipse.getWidth(), ellipse.getHeight());
            if (ellipse.getDeltaShadow() != 0.0) {
                this.drawShadow(g2d, shape, ellipse.getDeltaShadow(), this.dpiFactor);
            }
            if ((back = param.getBackcolor()) instanceof HColorGradient) {
                GradientPaint paint = DriverRectangleG2d.getPaintGradient(x, y, mapper, ellipse.getWidth(), ellipse.getHeight(), back);
                g2d.setPaint(paint);
                g2d.fill(shape);
                DriverRectangleG2d.drawBorder(param, color, mapper, ellipse, shape, g2d, x, y);
            } else {
                if (!back.isTransparent()) {
                    g2d.setColor(param.getBackcolor().toColor(mapper));
                    DriverRectangleG2d.managePattern(param, g2d);
                    g2d.fill(shape);
                }
                if (!color.isTransparent() && !color.equals(param.getBackcolor())) {
                    DriverRectangleG2d.drawBorder(param, color, mapper, ellipse, shape, g2d, x, y);
                }
            }
        } else {
            Arc2D.Double arc = new Arc2D.Double(x, y, ellipse.getWidth(), ellipse.getHeight(), DriverEllipseG2d.round(ellipse.getStart()), DriverEllipseG2d.round(ellipse.getExtend()), 0);
            if (!color.isTransparent()) {
                g2d.setColor(color.toColor(mapper));
                g2d.draw(arc);
            }
        }
    }

    static double round(double value) {
        return value;
    }
}

