/* vis550vdu.c - 18:41 GMT +10:00 Sat 12 Jun 1993 - modifier Geoffrey Tobin */

/* From input file "../include/globals.p" */

#include "config.h"
#include "globals.h"

#include "screenio.h"
#include "vdu.h"

#include "tek4010emu.h"
#include "vt100vdu.h"
#include "vis500vdu.h"

/******************************************************************************/

#ifdef __STDC__
Void VIS550MoveToTextLine (int line)
#else
Void VIS550MoveToTextLine (line)
  int line;
#endif
{
  /* Move current position to start of given line. */

  WriteChar (CAN);

  VT100MoveToTextLine (line);
}
/* VIS550MoveToTextLine */

/******************************************************************************/

#ifdef __STDC__
Void VIS550ClearTextLine (int line)
#else
Void VIS550ClearTextLine (line)
  int line;
#endif
{
  /* Erase given line; note that DVItoVDU does not assume anything about the
     current position at the end of this routine.
  */

  WriteChar (CAN);

  VT100ClearTextLine (line);
}
/* VIS550ClearTextLine */

/******************************************************************************/

Void VIS550ClearScreen (VOID)
{
  WriteChar (CAN);

  VT100ClearScreen();
  TEK4010ClearScreen();
}
/* VIS550ClearScreen */

/******************************************************************************/

/* VIS550ShowChar: use VIS500ShowChar */

/******************************************************************************/

/* VIS550ShowRectangle: use VIS500ShowRectangle */

/******************************************************************************/

/* VIS550ResetVDU: use VIS500ResetVDU */

/******************************************************************************/

Void InitVIS550 (VOID)
{
  /* The dialog region will be the top 4 text lines in VT100 mode:
        Line 1 = DVI status line,
        Line 2 = window status line,
        Line 3 = message line,
        Line 4 = command line.
     The window region will be text lines 5 to 33 in VT100 mode.
  */

  InitTEK4010emu();   /* We overwrite the things we don't want */
  DVIstatusl = 1;     /* DVItoVDU assumes top text line = 1 */
  windowstatusl = 2;
  messagel = 3;
  commandl = 4;
  bottoml = 33;       /* also = number of text lines on screen */

  /* The above values assume the VIS550 is in VT100 mode;
     the following values assume it is emulating a Tektronix 4010.
     Note that windowv must be given a value using DVItoVDU's coordinate scheme
     where top left pixel is (0,0).
  */

  windowv = 92;   /* approx. height in TEK4010 pixels of 4 text lines
                              i.e. ~ 4 * 780/34 */
  windowh = 0;
  windowht = 780 - windowv;
  windowwd = 1024;

  textlinewidth = 72;  /* text characters per line - a guess */

  MoveToTextLine = VIS550MoveToTextLine;
  ClearTextLine  = VIS550ClearTextLine;
  ClearScreen    = VIS550ClearScreen;
  StartText      = TEK4010StartText;
  StartGraphics  = TEK4010StartGraphics;
  LoadFont       = TEK4010LoadFont;
  ShowChar       = VIS500ShowChar;
  ShowRectangle  = VIS500ShowRectangle;
  ResetVDU       = VIS500ResetVDU;

  WriteChar (GS);

  WriteChar (ESC);
  WriteChar ('@');   /* solid fill for rectangular draw and fill */

  WriteChar (CAN);
}
/*InitVIS550 */

/******************************************************************************/

/* end vis550vdu.c */
