/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DviFile
extends JFrame {
    private DviMain m_Source;
    private JTextArea m_Log;
    private File m_ThisFile;
    private JScrollPane m_ScrollPane;
    private RandomAccessFile m_File = null;
    private DviPage m_Page = null;
    private long[] m_PageLoc;
    private int m_Num;
    private int m_Den;
    private int m_Mag;
    private double m_Scale;
    private int m_CurrentPage = 0;
    private int m_DefaultDoubleSide = -1;
    private int m_PaperOrient = 1;

    public DviFile(DviMain dviMain, File file) {
        super("DviFile");
        this.m_Source = dviMain;
        this.m_ThisFile = file;
        this.m_Log = this.m_Source.getLog();
        this.setTitle(this.m_ThisFile.getName());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        Serializable serializable = new DviMenuBar(this);
        container.add((Component)serializable, "North");
        this.m_Page = new DviPage(this);
        if (!this.openFile()) {
            this.m_Log.append("Not a valid DVI File.\n");
        }
        this.m_Page.setScale(this.m_Scale);
        this.setZoom(100);
        this.m_Page.setVisible(true);
        this.m_ScrollPane = new JScrollPane(this.m_Page, 22, 32);
        serializable = this.getPaperSize();
        Dimension dimension = new Dimension((int)((Dimension)serializable).getWidth(), (int)(0.75 * ((Dimension)serializable).getWidth()));
        this.m_ScrollPane.setPreferredSize(dimension);
        this.m_ScrollPane.setSize(dimension);
        container.add((Component)this.m_ScrollPane, "Center");
        this.m_Page.doPage(0);
        this.pack();
        ((Component)this).setVisible(true);
        this.m_ScrollPane.setVisible(true);
        this.m_Page.setVisible(true);
    }

    public int getUnsigned(int n) throws IOException {
        byte[] byArray = new byte[4];
        this.m_File.read(byArray, 0, n + 1);
        int n2 = byArray[0] & 0xFF;
        int n3 = 1;
        while (n3 <= n) {
            n2 = n2 << 8 | byArray[n3] & 0xFF;
            ++n3;
        }
        return n2;
    }

    public int getSigned(int n) throws IOException {
        byte[] byArray = new byte[4];
        this.m_File.read(byArray, 0, n + 1);
        int n2 = byArray[0];
        int n3 = 1;
        while (n3 <= n) {
            n2 = n2 << 8 | byArray[n3] & 0xFF;
            ++n3;
        }
        return n2;
    }

    public void seek(long l) throws IOException {
        this.m_File.seek(l);
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        this.m_File.read(byArray, n, n2);
    }

    public RandomAccessFile getFile() {
        return this.m_File;
    }

    public long getPageOffset(int n) {
        return this.m_PageLoc[n];
    }

    public double getScale() {
        return this.m_Scale;
    }

    public JTextArea getLog() {
        return this.m_Log;
    }

    public JScrollPane getScrollPane() {
        return this.m_ScrollPane;
    }

    public int getCurrentPage() {
        return this.m_CurrentPage;
    }

    public void setCurrentPage(int n) {
        this.m_CurrentPage = n;
        if (this.m_CurrentPage < 0) {
            this.m_CurrentPage = 0;
        } else if (this.m_CurrentPage > this.m_PageLoc.length - 2) {
            this.m_CurrentPage = this.m_PageLoc.length - 2;
        }
        this.m_Page.doPage(this.m_CurrentPage);
        this.m_Page.repaint();
    }

    public DviPage getPage() {
        return this.m_Page;
    }

    public void setZoom(int n) {
        this.m_Page.setViewScale(0.01 * (double)n);
    }

    public int getZoom() {
        return (int)(100.0 * this.m_Page.getViewScale());
    }

    public int getLastPageNumber() {
        return this.m_PageLoc.length - 2;
    }

    public int getDefaultDoubleSide() {
        if (this.m_DefaultDoubleSide < 0 || this.m_DefaultDoubleSide > 7) {
            String string = DviMain.getResourceString("PrintDoubleSided");
            try {
                this.m_DefaultDoubleSide = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("String \"" + string + "\" is not a valid integer");
                numberFormatException.printStackTrace();
                this.m_DefaultDoubleSide = 0;
            }
        }
        return this.m_DefaultDoubleSide;
    }

    public void setDefaultDoubleSide(int n) {
        this.m_DefaultDoubleSide = n;
        this.m_Source.setProperty("PrintDoubleSided", Integer.toString(n));
    }

    public int getNum() {
        return this.m_Num;
    }

    public int getDen() {
        return this.m_Den;
    }

    public int getMag() {
        return this.m_Mag;
    }

    public DviMain getSource() {
        return this.m_Source;
    }

    public DviPage getDviPage() {
        return this.m_Page;
    }

    public Dimension getPaperSize() {
        return this.m_Source.getPaperSize();
    }

    public int getPaperOrient() {
        return this.m_PaperOrient;
    }

    public void setPaperOrient(int n) {
        this.m_PaperOrient = n;
    }

    public void refresh() {
        System.out.println("Refresh");
        try {
            this.m_File.close();
        }
        catch (IOException iOException) {
            System.err.println("Close file error = " + iOException.getMessage());
            iOException.printStackTrace();
        }
        if (!this.openFile()) {
            this.m_Log.append("Not a valid DVI File.\n");
        }
        this.m_Page.doPage(this.m_CurrentPage);
        System.out.println("Current page = " + this.m_CurrentPage);
        this.pack();
        this.m_Page.setVisible(false);
        this.m_Page.setVisible(true);
        this.m_Page.paint(this.m_Page.getGraphics());
    }

    private boolean openFile() {
        System.out.println("OpenFile");
        try {
            this.m_File = new RandomAccessFile(this.m_ThisFile, "r");
            this.m_Log.append("File: " + this.m_ThisFile.getName());
            int n = this.getUnsigned(0);
            DviPRE dviPRE = new DviPRE(this);
            dviPRE.execute(n);
            this.m_Scale = dviPRE.getScale();
            this.m_Num = dviPRE.getNum();
            this.m_Den = dviPRE.getDen();
            this.m_Mag = dviPRE.getMag();
            long l = -1L;
            Object object = new DviSearchPostPost(this.m_File);
            l = ((DviSearchPostPost)object).getPostLoc();
            if (l < 0L) {
                this.m_Log.append("Not a DVI File (no POSTPOST command)\n");
                return false;
            }
            this.m_File.seek(l);
            n = this.getUnsigned(0);
            if (n != 248) {
                this.m_Log.append("Not a DVI File (no POST command)\n");
                return false;
            }
            object = new DviPOST(this);
            this.m_PageLoc = ((DviPOST)object).getPageLoc(l);
        }
        catch (IOException iOException) {
            System.out.println("File " + this.m_ThisFile.getName() + " exception:" + iOException);
            return false;
        }
        return true;
    }

    private int signedBytes(byte[] byArray, int n, int n2) {
        int n3 = byArray[n];
        int n4 = 1;
        while (n4 < n2) {
            n3 = n3 << 8 | byArray[n + n4] & 0xFF;
            ++n4;
        }
        return n3;
    }

    private int unsignedBytes(byte[] byArray, int n, int n2) {
        int n3 = byArray[n] & 0xFF;
        int n4 = 1;
        while (n4 < n2) {
            n3 = n3 << 8 | byArray[n + n4] & 0xFF;
            ++n4;
        }
        return n3;
    }
}

