/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.sh.command.basic;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.mvel2.sh.Command;
import org.mvel2.sh.ShellSession;
import org.mvel2.sh.text.TextUtil;
import org.mvel2.util.StringAppender;

public class ObjectInspector
implements Command {
    private static final int PADDING = 17;

    @Override
    public Object execute(ShellSession session, String[] args) {
        if (args.length == 0) {
            System.out.println("inspect: requires an argument.");
            return null;
        }
        if (!session.getVariables().containsKey(args[0])) {
            System.out.println("inspect: no such variable: " + args[0]);
            return null;
        }
        Object val = session.getVariables().get(args[0]);
        System.out.println("Object Inspector");
        System.out.println(TextUtil.paint('-', 17));
        if (val == null) {
            System.out.println("[Value is Null]");
            return null;
        }
        Class<?> cls = val.getClass();
        boolean serialized = true;
        long serializedSize = 0L;
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(outStream));
            objectOut.writeObject(val);
            objectOut.flush();
            outStream.flush();
            serializedSize = outStream.size();
        }
        catch (Exception e) {
            serialized = false;
        }
        ObjectInspector.write("VariableName", args[0]);
        ObjectInspector.write("Hashcode", val.hashCode());
        ObjectInspector.write("ClassType", cls.getName());
        ObjectInspector.write("Serializable", serialized);
        if (serialized) {
            ObjectInspector.write("SerializedSize", serializedSize + " bytes");
        }
        ObjectInspector.write("ClassHierarchy", ObjectInspector.renderClassHeirarchy(cls));
        ObjectInspector.write("Fields", cls.getFields().length);
        ObjectInspector.renderFields(cls);
        ObjectInspector.write("Methods", cls.getMethods().length);
        ObjectInspector.renderMethods(cls);
        System.out.println();
        return null;
    }

    private static String renderClassHeirarchy(Class cls) {
        LinkedList<String> list = new LinkedList<String>();
        list.add(cls.getName());
        while ((cls = cls.getSuperclass()) != null) {
            list.add(cls.getName());
        }
        StringAppender output2 = new StringAppender();
        for (int i = list.size() - 1; i != -1; --i) {
            output2.append((String)list.get(i));
            if (i - 1 == -1) continue;
            output2.append(" -> ");
        }
        return output2.toString();
    }

    private static void renderFields(Class cls) {
        Field[] fields2 = cls.getFields();
        for (int i = 0; i < fields2.length; ++i) {
            ObjectInspector.write("", fields2[i].getType().getName() + " " + fields2[i].getName());
        }
    }

    private static void renderMethods(Class cls) {
        Method[] methods2 = cls.getMethods();
        StringAppender appender = new StringAppender();
        for (int i = 0; i < methods2.length; ++i) {
            appender.append(TextUtil.paint(' ', 19));
            Method m = methods2[i];
            int mf = m.getModifiers();
            if ((mf & 1) != 0) {
                appender.append("public");
            } else if ((mf & 2) != 0) {
                appender.append("private");
            } else if ((mf & 4) != 0) {
                appender.append("protected");
            }
            appender.append(' ').append(m.getReturnType().getName()).append(' ').append(m.getName()).append("(");
            Class<?>[] parmTypes = m.getParameterTypes();
            for (int y = 0; y < parmTypes.length; ++y) {
                if (parmTypes[y].isArray()) {
                    appender.append(parmTypes[y].getComponentType().getName() + "[]");
                } else {
                    appender.append(parmTypes[y].getName());
                }
                if (y + 1 >= parmTypes.length) continue;
                appender.append(", ");
            }
            appender.append(")");
            if (m.getDeclaringClass() != cls) {
                appender.append("    [inherited from: ").append(m.getDeclaringClass().getName()).append("]");
            }
            if (i + 1 >= methods2.length) continue;
            appender.append('\n');
        }
        System.out.println(appender.toString());
    }

    private static void write(Object first2, Object second2) {
        System.out.println(TextUtil.padTwo(first2, ": " + second2, 17));
    }

    @Override
    public String getDescription() {
        return "inspects an object";
    }

    @Override
    public String getHelp() {
        return "No help yet";
    }
}

