{$N-,E-,V-}

Unit bibshow;

Interface

uses
  bibwindo, Dos, bibCrt, objects,
  bibstrg, bibecond, bibvars, bibutil, bibfile, lfnunit;

procedure ShowEntry(Entry: EntryRecPtr; Scroll: LongInt;
                    Var LastY: LongInt; edit: boolean;
                    PatternOn, ShowTags: boolean);


Implementation
 

procedure ShowEntry(Entry: EntryRecPtr; Scroll: LongInt;
                    Var LastY: LongInt; edit: boolean;
                    PatternOn, ShowTags: boolean);
var
  line,tmp: string;
  i,j,k,level,si,nbr,tx,ty,CharCase,etype,NewLines: integer;
  ch: char;
  Eval, LastEval, OnScreen, Exists, FoundEnd, IsIgnored: boolean;
  batt,Att,OAtt: Byte;
  Attrib: array[1..100] of integer;
  FileDrive: string[1];
  FilePath,FileName,FileExt: string;

procedure ShowError(s:string);
begin                                { ShowError }
  FatalError(s);
end;                                 { ShowError }

procedure CR(N: integer); forward;

procedure ClrLine;
begin
  if Onscreen and (tx<ScrWidth-1) then
    Tpwfill(ty+2-Scroll,tx+1,1,ScrWidth-1-tx,' ',EntryNorm);
end;

procedure prchar(ch: char);
begin                               { prchar }
  if OnScreen then Tpwprint(ty+2-Scroll,tx+1,ch,Att);
  Inc(tx);
  if tx=ScrWidth-1 then CR(0);
  NewLines:=0;
end;                                 { prchar }

procedure PrString(s: string; KeepCase,HideBraces: boolean);
var
  i,j,k,l,ll,cr_jump,j1,j2,icode,EolInd,BrDepth: integer;
  line,tmp: string;
  cut,beg,cr_find,ExtraBrace,Math,StrField: boolean;
begin                               { PrString }
  if (S='') or (s=EmptyFieldChar) then exit;
  OnScreen:=((ty>Scroll) and (ty<Scroll+ScrLen-2));
  beg:=true;
  BrDepth:=0; ExtraBrace:=false; Math:=false;
  StrField:=(S[1]='@');
  while s<>'' do
  begin
    cut:=false;
    cr_jump:=0; cr_find:=false;
    if (beg) or (tx=1) then ChrDelL(s,' ');
    beg:=false;
    l:=length(s);
    PStrCopy(line,s,1,ScrWidth-1-tx); ll:=length(line);
    if (ll<length(s)) and (ll=ScrWidth-1-tx) and
       (line[ll]<>' ') and (S[ll+1]<>' ') then
    begin
      i:=ChrPosR(line,' ',1);
      if i>0 then
      begin
        StrCut(line,i-1);
        cut:=true;
      end else if tx>1 then
      begin
        line:='';
        cut:=true;
      end;
    end;
    cr_jump:=0; cr_find:=false;
    EolInd:=0; k:=0;
    while EolDisplay and (EolInd=0) and (k<NEolStrings) do
    begin
      inc(k); j:=Pos(EolString[k]^,line);
      if j>0 then
      begin
        EolInd:=k; i:=j; j:=j+length(EolString[EolInd]^);
      end;
    end;
    if EolDisplay and (EolInd>0) and ((j>length(line)) or
           ((j<=length(line)) and (line[j] in [' ',lbrace,'[','\','~']))) then
    begin
      j2:=0;
      if (j>length(line)) or (line[j] in ['\','~']) then
      begin
        cr_find:=true;
        j2:=j-1;
      end else if line[j]=' ' then
      begin
        cr_find:=true;
        j2:=j; 
      end else if line[j]=lbrace then
      begin
        cr_find:=true;
        j2:=ChrPosX(line,rbrace,j+1);
        if j2>j+1 then
        begin
          icode:=0;
          val(Copy(line,j+1,j2-j-1),cr_jump,icode);
          if icode>0 then cr_jump:=0;
        end else if j2<j then j2:=j;
      end else if line[j]='[' then
      begin
        j2:=ChrPosX(line,']',j+1);
        if j2<j then j2:=j;
      end;
      Delete(S,1,j2-i+1);
      if i=1 then line:=''
      else begin
        StrCut(line,i-1); cut:=true;
      end;
      Delete(S,1,length(line));
      if (length(S)>0) and (S[1]=' ') then Delete(S,1,1);
      ChrDelR(line,' ');
    end else if line<>'' then
    begin
      if cut then Delete(S,1,length(line)+1)
      else Delete(S,1,length(line));
    end;
    if Onscreen then
    begin
      if TildeToSpace then
        for i:=1 to length(line) do
          if (line[i]='~') and ((i=1) or (line[i-1]<>'\')) then line[i]:=' ';
      if not KeepCase then
      begin
        if CharCase=-2 then StrUpr(line)
        else if CharCase=-3 then StrLwr(line);
      end;
      if HideBraces and not StrField then StripBraces(line,BrDepth,ExtraBrace,Math);
      Tpwprint(ty-Scroll+2,tx+1,line,Att);
    end;
    tx:=tx+length(line);
    if cut or cr_find then CR(cr_Jump)
    else if tx=ScrWidth-1 then
    begin
      tx:=1; Inc(ty);
      OnScreen:=((ty>Scroll) and (ty<Scroll+ScrLen-2));
    end;
  end;
  NewLines:=0;
end;                                 { PrString }

procedure pbig(S: BigTypePtr; Slen: Word; HideBraces: boolean);
var
  ind,l,i,j,k,lline,j1,j2,EolInd: Word;
  icode,BrDepth,cr_jump: integer;
  line,tmp: string;
  cut,beg,cr_find,ExtraBrace,Math,StrField: boolean;
begin                               { pbig }
  if (Slen=0) or ((Slen=1) and (S^[1]=EmptyFieldChar)) then Exit;
  OnScreen:=((ty>Scroll) and (ty<Scroll+ScrLen-2));
  ind:=1; beg:=true;
  BrDepth:=0; ExtraBrace:=false; Math:=false;
  StrField:=(S^[1]='@');
  while ind<=slen do
  begin
    cut:=false; line:='';
    cr_jump:=0; cr_find:=false;
    if beg or (tx=1) then while (ind<=Slen) and (S^[ind]=' ') do Inc(Ind);
    beg:=false;
    for i:=ind to imin(ind+ScrWidth-2-tx,slen) do PStrCat(line,S^[i],ScrWidth-2);
    if (ind+length(line)<=slen) and (length(line)=ScrWidth-1-tx) and
                  (line[length(line)]<>' ') and  (S^[ind]<>' ') then
    begin
      i:=ChrPosR(line,' ',1);
      if i>0 then
      begin
        StrCut(line,i-1);
        cut:=true;
      end else if tx>1 then
      begin
        line:='';
        cut:=true;
      end;
    end;
    cr_jump:=0; cr_find:=false;
    EolInd:=0; k:=0;
    while EolDisplay and (EolInd=0) and (k<NEolStrings) do
    begin
      inc(k); j:=Pos(EolString[k]^,line);
      if j>0 then
      begin
        EolInd:=k; i:=j; j:=j+length(EolString[EolInd]^);
      end;
    end;
    if EolDisplay and (EolInd>0) and ((j>length(line)) or
           ((j<=length(line)) and (line[j] in [' ',lbrace,'[','\','~']))) then
    begin
      j2:=0;
      if (j>length(line)) or (line[j] in ['\','~']) then
      begin
        cr_find:=true;
        j2:=j-1;
      end else if line[j]=' ' then
      begin
        cr_find:=true;
        j2:=j; 
      end else if line[j]=lbrace then
      begin
        cr_find:=true;
        j2:=ChrPosX(line,rbrace,j+1);
        if j2>j+1 then
        begin
          icode:=0;
          val(Copy(line,j+1,j2-j-1),cr_jump,icode);
          if icode>0 then cr_jump:=0;
        end else if j2<j then j2:=j;
      end else if line[j]='[' then
      begin
        j2:=ChrPosX(line,']',j+1);
        if j2<j then j2:=j;
      end;
      ind:=ind+j2-i+1;
      if i=1 then line:=''
      else begin
        StrCut(line,i-1); cut:=true;
      end;
      ind:=ind+length(line);
      if (ind<slen) and (S^[ind]=' ') then inc(ind);
      ChrDelR(line,' ');
    end else if line<>'' then
    begin
      ind:=ind+length(line);
      if cut then inc(ind);
    end;
    if Onscreen then
    begin
      if TildeToSpace then
        for i:=1 to length(line) do
          if (line[i]='~') and ((i=1) or (line[i-1]<>'\')) then line[i]:=' ';
      if CharCase=-2 then StrUpr(line)
      else if CharCase=-3 then StrLwr(line);
      if HideBraces then StripBraces(line,BrDepth,ExtraBrace,Math);
      Tpwprint(ty-Scroll+2,tx+1,line,Att);
    end;
    tx:=tx+length(line);
    if cut or cr_find then CR(cr_Jump)
    else if tx=ScrWidth-1 then
    begin
      tx:=1; Inc(ty);
      OnScreen:=((ty>Scroll) and (ty<Scroll+ScrLen-2));
    end;
  end;
  NewLines:=0;
end;                                 { pbig }

procedure emph(s: string; KeepCase: boolean);
begin
  OAtt:=Att; Att:=EntryBright;
  PrString(s,KeepCase,false); Att:=OAtt;
end;

function GetShowFormat(i: integer; first: boolean): char;
begin                            { GetShowFormat }
  if (i<1) or (i>ShowFormat[first].len) then 
    GetShowFormat:=#0
  else
    GetShowFormat:=ShowFormat[first].p^[i];
end;                                 { GetShowFormat }

procedure CR(N: integer);
var
  i: integer;
  negative: boolean;
begin
  negative:=false;
  if N<0 then
  begin
    N:=-N; Negative:=true;
  end;
  if (tx=1) and (ty=1) and (not negative) then N:=0;    { Eat leading spaces}
  if (not negative) and (NewLines>0) then
  begin
    N:=N-NewLines; if N<0 then N:=0;
  end;

  OnScreen:=((ty>Scroll) and (ty<Scroll+ScrLen-2));
  if tx>1 then    { CR(0) }
  begin
    if OnScreen then ClrLine;
    tx:=1; Inc(ty);
  end else tx:=1;
  
  if N>0 then
  begin
    ClrLine;
    for i:=1 to N do
      if ((ty+i+2-Scroll>2) and (ty+i+2-Scroll<ScrLen-1)) then
        Tpwfill(ty+i+2-Scroll,2,1,ScrWidth-2,' ',EntryNorm);
    tx:=1; ty:=ty+N;
  end;
  NewLines:=NewLines+N;
  OnScreen:=((ty>Scroll) and (ty<Scroll+ScrLen-2));
end;                           { CR }

begin                                { ShowEntry }
  shown.nshown:=0;
  if edit then batt:=EditBorder
  else Batt:=EntryNorm;
  Window(2,1,ScrLen-1,ScrWidth);
  LastY:=0;
  LFNFsplit(bibname^,@FilePath,@FileName,@FileExt);
  FileDrive:=FilePath[1]; Delete(FilePath,1,2);
  if (FileExt<>'') and (FileExt[1]='.') then Delete(FileExt,1,1);
  etype:=FindInETypeList(Entry^.EntryType);
  with Entry^ do
  begin
    ChrDel(EntryType,' '); Strlwr(EntryType);
    Tpwfill(2,2,1,ScrWidth-2,#205,batt);
    Tpwfill(ScrLen,2,1,ScrWidth-2,#205,batt);
    Tpwfill(3,1,ScrLen-3,1,#186,batt);
    TpwPrint(2,1,#201,batt);      TpwPrint(2,ScrWidth,#187,batt);
    TpwPrint(ScrLen,1,#200,batt); TpwPrint(ScrLen,ScrWidth,#188,batt);
{    Tpwfill(3,ScrWidth,ScrLen-3,1,#186,batt);}
    if not edit then
    begin
      line:=TruncateFilename(bibname^,30);
      if Linked then line:=Concat('+',line)
      else if BibReadOnly then line:=Concat('*',line);
      TitleWindow(4,EntryNorm,line);
    end;
    Tpwattr(2,1,ScrLen-1,1,batt);
    Tpwattr(2,ScrWidth,ScrLen-1,1,batt);
    if entrynum>0 then
    begin
      Str(realnum,line); ChrDel(line,' ');
      if PatternOn then
      begin
        Str(entrynum,tmp); ChrDel(tmp,' ');
        line:=Concat(tmp,#205,line);
      end;
      Titlewindow(3,batt,line);
    end;
    tmp:=entrytype+': '; StrUpr(tmp);
    if name<>'' then tmp:=tmp + name
    else tmp:=tmp+'<UnNamed>';
    if ShowTags and IsTagged(entry^.realnum,Tags) then
      Titlewindow(2,EntryNorm,TagChar+tmp)
    else Titlewindow(2,EntryNorm,tmp);
  end;
  tx:=1; ty:=1; Att:=EntryNorm;
  OnScreen:=((ty>Scroll) and (ty<Scroll+ScrLen-2));
  si:=0;
  nbr:=1; CharCase:=-1; FoundEnd:=false;
  repeat
    repeat
      inc(si);
    until (si=ShowFormat[FirstShowBuf].len) or 
          (GetShowFormat(si,FirstShowBuf)<>sf_NOP);
    ch:=GetShowFormat(si,FirstShowBuf);
    if ch=sf_BF then                        { begin \bf }
    begin
      Attrib[nbr]:=Att;
      inc(nbr);
      Att:=EntryBright;
    end else if ch=sf_Color then              { begin \color }
    begin
      Attrib[nbr]:=Att;
      inc(nbr);
      Att:=SpecialColors[Ord(GetShowFormat(si+1,FirstShowBuf))];
      Inc(si);
    end else if ch=sf_UpCase then              { begin \uc }
    begin
      Attrib[nbr]:=CharCase;
      inc(nbr);
      CharCase:=-2;
    end else if ch=sf_DnCase then              { begin \lc }
    begin
      Attrib[nbr]:=CharCase;
      inc(nbr);
      CharCase:=-3;
    end else if ch=sf_DefCase then              { begin \dc }
    begin
      Attrib[nbr]:=CharCase;
      inc(nbr);
      CharCase:=-1;
    end else if ch=sf_EndAtt then     { end attribute }
    begin
      dec(nbr);
      if Attrib[nbr]>0 then Att:=Attrib[nbr]
      else CharCase:=Attrib[nbr];
    end else if ch=sf_CR then                   { \cr }
    begin
      inc(si);
      CR(ShortInt(Ord(GetShowFormat(si,FirstShowBuf))));
    end else if (ch=sf_If) or (ch=sf_ElseIf) then  { \if and \elseif }
    begin
      inc(si); tmp:='';
      while GetShowFormat(si,FirstShowBuf)<>sf_EndIf do
      begin
        if GetShowFormat(si,FirstShowBuf)<>sf_NOP then
           PStrCat(tmp,GetShowFormat(si,FirstShowBuf),255);
        inc(si);
      end;
      if (ch=sf_If) then   {\if}
      begin
        if EvalCondition(entry,tmp,false,false,Nil) then
        begin
          LastEval:=true;
          inc(nbr);
        end else
        begin
          repeat
            inc(si);
          until (si>=ShowFormat[FirstShowBuf].len) or
                (Ord(GetShowFormat(si,FirstShowBuf))=sf_EndBrace+1+nbr);
          LastEval:=false;
        end;
      end else if ch=sf_ElseIf then  {\elseif}
      begin
        if LastEval then
        begin
          repeat
            inc(si);
          until (si>=ShowFormat[FirstShowBuf].len) or
                (Ord(GetShowFormat(si,FirstShowBuf))=sf_EndBrace+1+nbr);
        end else
        begin
          if EvalCondition(entry,tmp,false,false,Nil) then
          begin
            LastEval:=true;
            inc(nbr);
          end else
          begin
            repeat
              inc(si);
            until (si>=ShowFormat[FirstShowBuf].len) or
                  (Ord(GetShowFormat(si,firstShowBuf))=sf_EndBrace+1+nbr);
            LastEval:=false;
          end;
        end;
      end;
    end else if Ord(ch)>sf_EndBrace then  {close of good \if}
    begin
      dec(nbr);
      LastEval:=true;
    end else if ch=sf_FldName then   { The (possibly alternate) field name }
    begin
      inc(si); j:=Ord(GetShowFormat(si,FirstShowBuf))-sfFld_Offset;
      if FieldParams^[j].AltName<>Nil then tmp:=FieldParams^[j].AltName^
      else begin
        tmp:=TypeField^[j]; tmp[1]:=UpCase(tmp[1]);
      end;
      PrString(tmp,false,false);
    end else if ch in [sf_Field,sf_Field1,sf_Field2,sf_Field3] then  { fields }
    begin
      inc(si); Exists:=false;
      if GetShowFormat(si,FirstShowBuf)=sfFld_Name then         { Name }
        Exists:=(entry^.name<>'')
      else if GetShowFormat(si,FirstShowBuf) in
        [sfFld_flFull,sfFld_flDrive,sfFld_flPath,sfFld_flName,sfFld_flExt,sfFld_Type]
         then Exists:=true   { file name components, Type }
      else begin                                          { Field name }
        j:=Ord(GetShowFormat(si,FirstShowBuf))-sfFld_Offset;
        Exists:=((j=StringIndex) or (j<=Entry^.LastField)) and
                (entry^.index[j]>0);
        if (not Exists) and (not FirstShowBuf) then
          Exists:=(Pos(chr(j),Pstring(@required^[etype])^)>0)
             or (Pos(chr(byte(-j)),Pstring(@required^[etype])^)>0);
      end;
      if Exists then
      begin
        if ch in [sf_Field1,sf_Field3] then CR(0);
        if ch=sf_Field3 then CR(1);
        if GetShowFormat(si,FirstShowBuf)=sfFld_flFull then         { Full file path }
        begin
          if ch<>sf_Field then emph('File: ',true);
          PrString(bibname^,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_flDrive then    { File drive }
        begin
          if ch<>sf_Field then emph('File drive: ',true);
          PrString(FileDrive,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_flPath then    { File path }
        begin
          if ch<>sf_Field then emph('File path: ',true);
          PrString(FilePath,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_flName then    { File name }
        begin
          if ch<>sf_Field then emph('File name: ',true);
          PrString(FileName,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_flExt then    { File extension }
        begin
          if ch<>sf_Field then emph('File extension: ',true);
          PrString(FileExt,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_Name then    { Entry Name }
        begin
          if ch<>sf_Field then emph('Entry name: ',true);
          PrString(Entry^.name,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_Type then    { Entry Type }
        begin
          if ch<>sf_Field then emph('Entry type: ',true);
          tmp:=Entry^.entrytype; tmp[1]:=UpCase(tmp[1]);
          PrString(tmp,false,false);
        end else
        begin                                                   { Field }
          j:=Ord(GetShowFormat(si,FirstShowBuf))-sfFld_Offset;
          isIgnored:=true;
          for k:=1 to Required^[etype,0] do
            if j=abs(Required^[etype,k]) then IsIgnored:=false;
          
          inc(shown.nshown);
          shown.who[shown.nshown]:=j;
          shown.x1[shown.nshown]:=tx+1;
          shown.y1[shown.nshown]:=ty+2-Scroll;
          k:=entry^.index[j];
          if ch<>sf_Field then
          begin
            if FieldParams^[j].AltName<>Nil then tmp:=FieldParams^[j].AltName^+': '
            else begin
              tmp:=TypeField^[j]+': '; tmp[1]:=UpCase(tmp[1]);
            end;
            {
            if k>0 then tmp:=entry^.field[k]+': '
            else tmp:=TypeField^[j]+': ';
            tmp[1]:=UpCase(tmp[1]);
            }
            emph(tmp,true);
          end;
          if k>0 then
          begin
            if Pos(BinaryFields^,entry^.field[k])=1 then
              PrString('<binary data>',false,not IsIgnored)
            else if entry^.BigIndex[j]=0 then
              PrString(entry^.content[k],false,not IsIgnored)
            else
              Pbig(entry^.Big[entry^.BigIndex[j]],entry^.Blen[entry^.BigIndex[j]],
                   not IsIgnored);
          end;
          if tx=1 then
          begin
            shown.x2[shown.nshown]:=ScrWidth-1;
            shown.y2[shown.nshown]:=ty+2-Scroll;
          end else
          begin
            shown.x2[shown.nshown]:=tx;
            shown.y2[shown.nshown]:=ty+2-Scroll;
          end;
        end;
        if (ch in [sf_Field1,sf_Field3]) then CR(0);
      end;
    end else if (ch=sf_EOL) then CR(0)           { Explicit CR }
    else if ch=sf_Quote then                       { ASCII char }
    begin
      inc(si); prchar(GetShowFormat(si,FirstShowBuf));
    end else if ch=sf_END then FoundEnd:=true
    else if (ch<>sf_NOP) then{ prchar(ch);}       { Characters in the \ShowFormat }
    begin
      if ch=' ' then
      begin
        prchar(ch); inc(si);
      end;
      i:=si;
      while (i<ShowFormat[FirstShowBuf].len) and
            (GetShowFormat(i,FirstShowBuf)>=' ') and
            (Ord(GetShowFormat(i,FirstShowBuf))<sf_EndBrace) do inc(i);
      dec(i);
      Pbig(@ShowFormat[FirstShowBuf].p^[si],i-si+1,false);
      si:=i;
    end;
  until (si>=ShowFormat[FirstShowBuf].len) or (nbr<1) or (FoundEnd);
  LastY:=ty;
  ClrLine; inc(ty);
  i:=imax(3,ty-Scroll+2);
  if i<ScrLen then Tpwfill(i,2,ScrLen-i,ScrWidth-2,' ',EntryNorm);
end;                                   { ShowEntry }


end.
