package com.dickimawbooks.jmakepdfx;

import java.awt.*;
import java.io.*;
import java.net.*;
import java.awt.event.*;
import javax.swing.*;

public class LicenceDialog extends JDialog
   implements ActionListener
{
   public LicenceDialog(Jmakepdfx application)
     throws IOException
   {
      super(application, application.getLabel("help.license"), false);

      String resource = "/resources/LICENSE";
      URL url = application.getClass().getResource(resource);

      if (url == null)
      {
         throw new FileNotFoundException(
            application.getLabelWithValue("error.resource.cant_locate", resource));
      }

      String text = "";

      BufferedReader in = null;

      try
      {
         in = new BufferedReader(new InputStreamReader(url.openStream()));

         String line;

         while ((line = in.readLine()) != null)
         {
            text += line + "\n";
         }
      }
      finally
      {
         if (in != null)
         {
            in.close();
         }
      }

      JTextArea licencePane = new JTextArea(text);
      licencePane.setRows(70);
      licencePane.setEditable(false);

      getContentPane().add(new JScrollPane(licencePane), "Center");

      JPanel buttonPanel = new JPanel();
      getContentPane().add(buttonPanel, "South");

      buttonPanel.add(JpdfxResources.createOkayButton(this));

      pack();
      setLocationRelativeTo(application);
   }

   public void actionPerformed(ActionEvent evt)
   {
      String action = evt.getActionCommand();

      if (action == null) return;

      if (action.equals("okay"))
      {
         setVisible(false);
      }
   }

}
