/* Token.h
 *
 * The text to be parsed is broken into fundamental units called tokens.
 * To parse the LaTeX files, the program interprets and handles these tokens.
 *
 * Copyright 1992 Jonathan Monsarrat. Permission given to freely distribute,
 * edit and use as long as this copyright statement remains intact.
 *
 */

#include "LameTeX.h"

class Token {
   char _text[MAXSTRING];
   int _valid;
   static int _comment;            // Is this token placed inside a comment?

 public:
   Token();                        // Retrieve a new token from a file.

   void handle();                  // Deal with this token appropriately.
   int isvalid();                  // Is this token valid?
   void make_text(char *);
   char *get_text();
   int match(char *);
};
