/* licomsym.h  Symbol table common for sharing between LTX2X & code interp */

#ifndef licomsym_h
#define licomsym_h

#include "l2xicmon.h"

/* value structure */
typedef union {
  XPRSAINT integer;
  XPRSAREAL real;
  char character;
  char *stringp;
} VALUE;

/* definition structure */

typedef enum {
#define dfntc(a, b) a,
#include "l2xidftc.h"
#undef dfntc
} DEFN_KEY;



typedef enum {
  DECLARED,
  FORWARD,
  READ,
  READLN,
  WRITE,
  WRITELN,
  ABS,
  COS,
  EOFF,
  EOLN,
  EXP,
  ODD,
  ROUND,
  SIN,
  SQRT,
  TRUNC,
  L2XPRINT, 
  L2XPRINTLN,
  L2XSYSTEM,
  L2XREXPR,
  XACOS,   
  XASIN,
  XATAN,
  XBLENGTH,
  XEXISTS,
  XFORMAT,
  XHIBOUND,
  XHIINDEX,
  XLENGTH,
  XLOBOUND,
  XLOG,
  XLOG2,
  XLOG10,
  XLOINDEX,
  XNVL,
  XROLESOF,
  XSIZEOF,
  XTAN,
  XTYPEOF,
  XUSEDIN,
  XVALUE,
  XVALUE_IN,
  XVALUE_UNIQUE,
  XINSERT,   
  XREMOVE,
} ROUTINE_KEY;

typedef struct {
  DEFN_KEY key;
  union {
    struct {
      VALUE value;
    } constant;

    struct {
      ROUTINE_KEY key;
      int parm_count;
      int total_parm_size;
      int total_local_size;
      struct symtab_node *parms;
      struct symtab_node *locals;
      struct symtab_node *local_symtab;
      ICT *code_segment;
    } routine;

    struct {
      int offset;
      struct symtab_node *entity_idp;
    } data;
  } info;
} DEFN_STRUCT;

/* type structure */

typedef enum {
#define fotc(a, b, c, d) c,
#define sotc(a, b, c, d)
#define sftc(a, b, c, d) c,
#include "l2xisftc.h"
#undef fotc
#undef sotc
#undef sftc
} TYPE_FORM;

typedef struct type_struct {
  TYPE_FORM form;
  int size;
  struct symtab_node *type_idp;
  union {
    struct {
      struct symtab_node *const_idp;
      int max;
    } enumeration;

    struct {
      struct type_struct *range_typep;
      int min;
      int max;
    } subrange;

    struct {
      struct type_struct *bound_typep;
      int min;
      int max;
    } bound;

    struct {
      struct type_struct *index_typep;
      struct type_struct *elmt_typep;
      int min_index;
      int max_index;
      int elmt_count;
    } array;
  
    struct {
      struct type_struct *index_typep;
      struct type_struct *elmt_typep;
      int min_index;
      int max_index;
      int elmt_count;
    } dynagg;
  
    struct {
      struct symtab_node *attribute_symtab;
    } entity;

    struct {
      int max_length;
      int length;
    } string;
  } info;
} TYPE_STRUCT, *TYPE_STRUCT_PTR;

/* symbol table node */
typedef struct symtab_node {
  struct symtab_node *left, *right;  /* ptrs to subtrees */
  struct symtab_node *next;          /* for chaining nodes */
  char *name;                        /* name string */
  char *info;                        /* ptr to generic info */
  DEFN_STRUCT defn;                  /* definition struct */
  TYPE_STRUCT_PTR typep;             /* ptr to type struct */
  int level;                         /* nesting level */
  int label_index;                   /* index for code label */
} SYMTAB_NODE, *SYMTAB_NODE_PTR;

typedef int LOGICAL_REP;

#endif

