/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.GlyfCompositeComp;
import org.apache.fontbox.ttf.GlyfDescript;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.GlyphDescription;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.TTFDataStream;

public class GlyfCompositeDescript
extends GlyfDescript {
    private static final Log LOG = LogFactory.getLog(GlyfCompositeDescript.class);
    private final List<GlyfCompositeComp> components = new ArrayList<GlyfCompositeComp>();
    private GlyphTable glyphTable = null;
    private boolean beingResolved = false;
    private boolean resolved = false;

    public GlyfCompositeDescript(TTFDataStream bais, GlyphTable glyphTable) throws IOException {
        super((short)-1, bais);
        GlyfCompositeComp comp;
        this.glyphTable = glyphTable;
        do {
            comp = new GlyfCompositeComp(bais);
            this.components.add(comp);
        } while ((comp.getFlags() & 0x20) != 0);
        if ((comp.getFlags() & 0x100) != 0) {
            this.readInstructions(bais, bais.readUnsignedShort());
        }
    }

    @Override
    public void resolve() {
        if (this.resolved) {
            return;
        }
        if (this.beingResolved) {
            LOG.error("Circular reference in GlyfCompositeDesc");
            return;
        }
        this.beingResolved = true;
        int firstIndex = 0;
        int firstContour = 0;
        for (GlyfCompositeComp comp : this.components) {
            comp.setFirstIndex(firstIndex);
            comp.setFirstContour(firstContour);
            GlyphDescription desc = this.getGlypDescription(comp.getGlyphIndex());
            if (desc == null) continue;
            desc.resolve();
            firstIndex += desc.getPointCount();
            firstContour += desc.getContourCount();
        }
        this.resolved = true;
        this.beingResolved = false;
    }

    @Override
    public int getEndPtOfContours(int i) {
        GlyfCompositeComp c = this.getCompositeCompEndPt(i);
        if (c != null) {
            GlyphDescription gd = this.getGlypDescription(c.getGlyphIndex());
            return gd.getEndPtOfContours(i - c.getFirstContour()) + c.getFirstIndex();
        }
        return 0;
    }

    @Override
    public byte getFlags(int i) {
        GlyfCompositeComp c = this.getCompositeComp(i);
        if (c != null) {
            GlyphDescription gd = this.getGlypDescription(c.getGlyphIndex());
            return gd.getFlags(i - c.getFirstIndex());
        }
        return 0;
    }

    @Override
    public short getXCoordinate(int i) {
        GlyfCompositeComp c = this.getCompositeComp(i);
        if (c != null) {
            GlyphDescription gd = this.getGlypDescription(c.getGlyphIndex());
            int n = i - c.getFirstIndex();
            short x = gd.getXCoordinate(n);
            short y = gd.getYCoordinate(n);
            short x1 = (short)c.scaleX(x, y);
            x1 = (short)(x1 + c.getXTranslate());
            return x1;
        }
        return 0;
    }

    @Override
    public short getYCoordinate(int i) {
        GlyfCompositeComp c = this.getCompositeComp(i);
        if (c != null) {
            GlyphDescription gd = this.getGlypDescription(c.getGlyphIndex());
            int n = i - c.getFirstIndex();
            short x = gd.getXCoordinate(n);
            short y = gd.getYCoordinate(n);
            short y1 = (short)c.scaleY(x, y);
            y1 = (short)(y1 + c.getYTranslate());
            return y1;
        }
        return 0;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public int getPointCount() {
        GlyfCompositeComp c;
        GlyphDescription gd;
        if (!this.resolved) {
            LOG.error("getPointCount called on unresolved GlyfCompositeDescript");
        }
        if ((gd = this.getGlypDescription((c = this.components.get(this.components.size() - 1)).getGlyphIndex())) == null) {
            LOG.error("getGlypDescription(" + c.getGlyphIndex() + ") is null, returning 0");
            return 0;
        }
        return c.getFirstIndex() + gd.getPointCount();
    }

    @Override
    public int getContourCount() {
        if (!this.resolved) {
            LOG.error("getContourCount called on unresolved GlyfCompositeDescript");
        }
        GlyfCompositeComp c = this.components.get(this.components.size() - 1);
        return c.getFirstContour() + this.getGlypDescription(c.getGlyphIndex()).getContourCount();
    }

    public int getComponentCount() {
        return this.components.size();
    }

    private GlyfCompositeComp getCompositeComp(int i) {
        for (GlyfCompositeComp c : this.components) {
            GlyphDescription gd = this.getGlypDescription(c.getGlyphIndex());
            if (c.getFirstIndex() > i || i >= c.getFirstIndex() + gd.getPointCount()) continue;
            return c;
        }
        return null;
    }

    private GlyfCompositeComp getCompositeCompEndPt(int i) {
        for (GlyfCompositeComp c : this.components) {
            GlyphDescription gd = this.getGlypDescription(c.getGlyphIndex());
            if (c.getFirstContour() > i || i >= c.getFirstContour() + gd.getContourCount()) continue;
            return c;
        }
        return null;
    }

    private GlyphDescription getGlypDescription(int index) {
        try {
            GlyphData glyph = this.glyphTable.getGlyph(index);
            if (glyph != null) {
                return glyph.getDescription();
            }
            return null;
        }
        catch (IOException e) {
            LOG.error(e);
            return null;
        }
    }
}

