/* fsync.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

int __fsync(int fd)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();

    if (fd >= N_FILES || fd < 0)
	return _rsxnt_errno(EBADF);
    if (p->file[fd].f_handle == INVALID_HANDLE_VALUE)
	return _rsxnt_errno(EBADF);

    if (FlushFileBuffers(p->file[fd].f_handle) == FALSE)
	return _rsxnt_get_last_errno();
    else
	return 0;
}
