/*
 * Decompiled with CFR 0.152.
 */
package nts.builder;

import nts.base.Dimen;
import nts.base.Glue;
import nts.base.Num;
import nts.io.Log;
import nts.io.Loggable;
import nts.node.Box;
import nts.node.BoxLeaders;
import nts.node.BoxSizes;
import nts.node.Language;
import nts.node.Leaders;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.PenaltyNode;

public abstract class Builder
implements Loggable {
    public static final Builder NULL;
    private static Builder topBuilder;
    protected Builder enclosing = null;

    public boolean isHorizontal() {
        return false;
    }

    public boolean isVertical() {
        return false;
    }

    public boolean isMath() {
        return false;
    }

    public boolean isInner() {
        return false;
    }

    public boolean isCharAllowed() {
        return false;
    }

    public boolean wantsMigrations() {
        return false;
    }

    public boolean willBeBroken() {
        return false;
    }

    public boolean forbidsThirdPartOfDiscretionary() {
        return false;
    }

    public abstract void addNode(Node var1);

    public abstract void addNodes(NodeEnum var1);

    public abstract void addKern(Dimen var1);

    public abstract void addSkip(Glue var1);

    public abstract void addNamedSkip(Glue var1, String var2);

    public abstract void addRule(BoxSizes var1);

    public abstract void addLeaders(Glue var1, Leaders var2);

    public abstract void addLeadRule(Glue var1, BoxSizes var2, String var3);

    public void addSkip(Glue skip, String name) {
        if (name != null) {
            this.addNamedSkip(skip, name);
        } else {
            this.addSkip(skip);
        }
    }

    public void addPenalty(Num pen) {
        this.addNode(new PenaltyNode(pen));
    }

    public void addBox(Node box) {
        this.addNode(box);
    }

    public boolean unBox(Box box) {
        return false;
    }

    public BoxLeaders.Mover getBoxLeadMover() {
        return null;
    }

    public int getStartLine() {
        return 0;
    }

    public int getSpaceFactor() {
        return 0;
    }

    public void setSpaceFactor(int sf) {
    }

    public void resetSpaceFactor() {
    }

    public void adjustSpaceFactor(int sf) {
        throw new RuntimeException("char not allowed");
    }

    public Dimen getPrevDepth() {
        return null;
    }

    public void setPrevDepth(Dimen pd) {
    }

    public void buildPage() {
    }

    public NodeList getParagraph() {
        return null;
    }

    public boolean needsParSkip() {
        return false;
    }

    public boolean canTakeLastNode() {
        return true;
    }

    public boolean canTakeLastBox() {
        return this.canTakeLastNode();
    }

    public Language getInitLang() {
        return null;
    }

    public Language getCurrLang() {
        return null;
    }

    public void setCurrLang(Language lang) {
    }

    public abstract boolean isEmpty();

    public abstract Node lastNode();

    public abstract void removeLastNode();

    public abstract Node lastSpecialNode();

    public void show(Log log, int depth, int breadth) {
        log.startLine().add("### ");
        this.addOn(log);
        log.add(" entered at line ").add(this.getStartLine());
        this.specialShow(log, depth, breadth);
    }

    protected void specialShow(Log log, int depth, int breadth) {
    }

    public void addOn(Log log) {
        log.add(this.modeName()).add(" mode");
    }

    public abstract String modeName();

    public static final Builder top() {
        return topBuilder;
    }

    public static final void push(Builder b) {
        Builder builder = b;
        synchronized (builder) {
            if (b.enclosing != null) {
                throw new RuntimeException("builder alrady pushed");
            }
            b.enclosing = topBuilder;
            topBuilder = b;
        }
    }

    public static final Builder pop() {
        Builder b = topBuilder;
        if (b != null) {
            Builder builder = b;
            synchronized (builder) {
                topBuilder = b.enclosing;
                b.enclosing = null;
            }
        }
        return b;
    }

    public static void showStack(Log log, int depth, int breadth) {
        Builder b = topBuilder;
        while (b != null) {
            b.show(log, depth, breadth);
            b = b.enclosing;
        }
    }

    public int getPrevGraf() {
        return this.enclosing != null ? this.enclosing.getPrevGraf() : 0;
    }

    public void setPrevGraf(int pg) {
        if (this.enclosing != null) {
            this.enclosing.setPrevGraf(pg);
        }
    }

    public int nearestValidSpaceFactor() {
        return this.enclosing != null ? this.enclosing.getSpaceFactor() : 0;
    }

    public Dimen nearestValidPrevDepth() {
        return this.enclosing != null ? this.enclosing.getPrevDepth() : null;
    }

    static {
        topBuilder = null;
    }
}

