/*
 * Decompiled with CFR 0.152.
 */
package nts.dvi;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DviOutputStream
extends FilterOutputStream {
    private static final int DEFAULT_BUF_SIZE = 16384;
    private final int half;
    private final byte[] buffer;
    private int offset = 0;
    private int gone = 0;
    private int ptr = 0;
    private int limit;

    public void write(int b) throws IOException {
        this.buffer[this.ptr++] = (byte)b;
        if (this.ptr == this.limit) {
            if (this.limit == this.half) {
                this.limit = this.buffer.length;
            } else {
                this.offset += this.ptr;
                this.ptr = 0;
                this.limit = this.half;
            }
            this.out.write(this.buffer, this.ptr, this.half);
            this.gone += this.half;
        }
    }

    public void flush() throws IOException {
        if (this.limit == this.half) {
            this.out.write(this.buffer, this.half, this.half);
            this.gone += this.half;
        }
        if (this.ptr > 0) {
            this.out.write(this.buffer, 0, this.ptr);
            this.gone += this.ptr;
            this.offset += this.ptr;
            this.ptr = 0;
        }
        this.out.flush();
        this.limit = this.buffer.length;
    }

    public boolean dropLast() {
        if (this.ptr > 0) {
            --this.ptr;
            return true;
        }
        return false;
    }

    public int pos() {
        return this.offset + this.ptr;
    }

    public boolean present(int pos) {
        return pos >= this.gone && pos < this.offset + this.ptr;
    }

    public int get(int pos) {
        if (pos >= this.gone && (pos -= this.offset) < this.ptr) {
            if (pos < 0) {
                pos += this.buffer.length;
            }
            return this.buffer[pos] & 0xFF;
        }
        return -1;
    }

    public boolean set(int pos, int b) {
        if (pos >= this.gone && (pos -= this.offset) < this.ptr) {
            if (pos < 0) {
                pos += this.buffer.length;
            }
            this.buffer[pos] = (byte)b;
            return true;
        }
        return false;
    }

    public DviOutputStream(OutputStream out, int size) {
        super(out);
        if (size <= 0) {
            size = 16384;
        }
        size = size + 7 & 0xFFFFFFF8;
        this.half = size / 2;
        this.buffer = new byte[size];
        this.limit = size;
    }

    public DviOutputStream(OutputStream out) {
        this(out, 0);
    }
}

