/*
 * Decompiled with CFR 0.152.
 */
package nts.io;

import nts.io.CharCode;
import nts.io.LineOutput;
import nts.io.Log;
import nts.io.Loggable;

public class StandardLog
implements Log {
    protected final LineOutput out;
    protected final Escape esc;

    public final LineOutput getOutput() {
        return this.out;
    }

    public final Escape getEscape() {
        return this.esc;
    }

    public final Log add(char ch) {
        this.out.add(ch);
        return this;
    }

    public final Log add(char ch, int count) {
        while (count-- > 0) {
            this.out.add(ch);
        }
        return this;
    }

    public final Log add(String str) {
        this.out.add(str);
        return this;
    }

    public final Log add(CharCode code) {
        this.out.add(code);
        return this;
    }

    public final Log endLine() {
        this.out.endLine();
        return this;
    }

    public final Log startLine() {
        this.out.startLine();
        return this;
    }

    public final Log flush() {
        this.out.flush();
        return this;
    }

    public final void close() {
        this.out.close();
    }

    public final Log add(boolean val) {
        return this.add(String.valueOf(val));
    }

    public final Log add(int num) {
        return this.add(String.valueOf(num));
    }

    public final Log addEsc() {
        CharCode escape = this.esc.getEscape();
        return escape != null ? this.add(escape) : this;
    }

    public final Log addEsc(String str) {
        this.addEsc();
        return this.add(str);
    }

    public final Log add(Loggable x) {
        x.addOn(this);
        return this;
    }

    public Log add(Loggable[] array) {
        return this.add(array, 0, array.length);
    }

    public Log add(Loggable[] array, int offset, int length) {
        int i = 0;
        while (i < length) {
            this.add(array[offset + i++]);
        }
        return this;
    }

    public final Log resetCount() {
        this.out.resetCount();
        return this;
    }

    public final int getCount() {
        return this.out.getCount();
    }

    public final Log voidCounter() {
        return new StandardLog(this.out.voidCounter(), this.esc);
    }

    public final Log sepRoom(int count) {
        if (!this.out.stillFits(count)) {
            this.out.endLine();
        } else if (!this.out.isStartLine()) {
            this.out.add(' ');
        }
        return this;
    }

    public StandardLog(LineOutput out, Escape esc) {
        this.out = out;
        this.esc = esc;
    }

    public static interface Escape {
        public CharCode getEscape();
    }
}

