/*
 * Decompiled with CFR 0.152.
 */
package nts.noad;

import java.io.Serializable;
import nts.base.Dimen;
import nts.io.CntxLog;
import nts.io.Log;
import nts.noad.Converter;
import nts.noad.Egg;
import nts.noad.Field;
import nts.noad.FollowNodeEgg;
import nts.noad.Noad;
import nts.node.Box;
import nts.node.HBoxNode;
import nts.node.HShiftNode;
import nts.node.IntVKernNode;
import nts.node.MathWordBuilder;
import nts.node.Node;
import nts.node.NodeList;
import nts.node.TreatNode;
import nts.node.VBoxNode;
import nts.node.VShiftNode;

public abstract class BaseNoad
implements Noad {
    public boolean acceptsLimits() {
        return false;
    }

    public boolean isScriptable() {
        return false;
    }

    public boolean isOrdinary() {
        return false;
    }

    public boolean isJustChar() {
        return false;
    }

    public boolean alreadySuperScripted() {
        return false;
    }

    public boolean alreadySubScripted() {
        return false;
    }

    public boolean canPrecedeBin() {
        return true;
    }

    public boolean canFollowBin() {
        return true;
    }

    public Noad withLimits(byte limits) {
        return this;
    }

    public Field ordinaryField() {
        return null;
    }

    public void addOnWithScripts(Log log, CntxLog cntx, Field sup, Field sub) {
        this.addOn(log, cntx);
        sup.addOn(log, cntx, '^');
        sub.addOn(log, cntx, '_');
    }

    public Egg convertWithScripts(Converter conv, Field sup, Field sub) {
        return BaseNoad.makeScriptsTo(this.convert(conv), !this.isJustChar(), conv, sup, sub);
    }

    protected static Egg makeScriptsTo(Egg body, boolean notJustChar, Converter conv, Field sup, Field sub) {
        Node scripts;
        Serializable italCorr;
        Node supNode = null;
        Node subNode = null;
        Dimen supShift = Dimen.ZERO;
        Dimen subShift = Dimen.ZERO;
        Dimen delta = Dimen.ZERO;
        if (!sup.isEmpty()) {
            supNode = BaseNoad.makeScriptBox(sup, conv, (byte)3);
            if (notJustChar) {
                supShift = body.getHeight().max(Dimen.ZERO).minus(conv.getDimPar(12, (byte)3));
            }
        }
        if (!sub.isEmpty()) {
            subNode = BaseNoad.makeScriptBox(sub, conv, (byte)2);
            if (notJustChar) {
                subShift = body.getDepth().max(Dimen.ZERO).plus(conv.getDimPar(13, (byte)2));
            }
            if ((italCorr = body.getItalCorr()) != null) {
                delta = italCorr;
                body.suppressItalCorr();
            }
        }
        Dimen xHeight = conv.getDimPar(0).absolute();
        if (supNode == null) {
            if (subNode == null) {
                return body;
            }
            subShift = subShift.max(conv.getDimPar(10));
            subShift = subShift.max(subNode.getHeight().minus(xHeight.times(4, 5)));
            italCorr = HShiftNode.shiftingDown(subNode, subShift);
        } else {
            supShift = supShift.max(conv.getDimPar(conv.isCramped() ? 9 : (conv.getStyle() == 0 ? 7 : 8)));
            supShift = supShift.max(supNode.getDepth().plus(xHeight.over(4)));
            if (subNode == null) {
                italCorr = HShiftNode.shiftingUp(supNode, supShift);
            } else {
                subShift = subShift.max(conv.getDimPar(11));
                Dimen clr = conv.getDimPar(17).times(4).minus(supShift.minus(supNode.getDepth()).minus(subNode.getHeight().minus(subShift)));
                if (clr.moreThan(0)) {
                    subShift = subShift.plus(clr);
                    clr = xHeight.times(4, 5).minus(supShift.minus(supNode.getDepth()));
                    if (clr.moreThan(0)) {
                        supShift = supShift.plus(clr);
                        subShift = subShift.minus(clr);
                    }
                }
                NodeList list = new NodeList(3);
                list.append(VShiftNode.shiftingRight(supNode, delta)).append(new IntVKernNode(supShift.minus(supNode.getDepth()).minus(subNode.getHeight().minus(subShift)))).append(subNode);
                scripts = VBoxNode.packedOf(list);
                scripts = HShiftNode.shiftingDown(scripts, subShift);
            }
        }
        return new FollowNodeEgg(body, scripts);
    }

    private static Node makeScriptBox(Field field, Converter conv, byte how) {
        Node node = field.cleanBox(conv, how);
        Dimen dim = conv.scriptSpace();
        Box box = node.isBox() ? node.getBox() : HBoxNode.packedOf(node);
        return box.pretendingWidth(box.getWidth().plus(dim));
    }

    public boolean startsWord() {
        return false;
    }

    public boolean canBePartOfWord() {
        return false;
    }

    public boolean finishesWord() {
        return true;
    }

    public MathWordBuilder getMathWordBuilder(Converter conv, TreatNode proc) {
        throw new RuntimeException("not start of math word");
    }

    public byte wordFamily() {
        return -1;
    }

    public void contributeToWord(MathWordBuilder word) {
        throw new RuntimeException("cannot contribute to math word");
    }

    public Egg wordFinishingEgg(MathWordBuilder word, Converter conv) {
        throw new RuntimeException("not part of math word");
    }

    public Egg wordFinishingEggWithScripts(MathWordBuilder word, Converter conv, Field sup, Field sub) {
        return this.wordFinishingEgg(word, conv);
    }

    public abstract boolean isNode();

    public abstract Node getNode();

    public abstract Egg convert(Converter var1);

    public abstract boolean influencesBin();

    public abstract void addOn(Log var1, CntxLog var2);
}

